package zio.aws.gamelift.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.gamelift.model.primitives.{
  PositiveInteger,
  DnsName,
  StringModel,
  ArnStringModel
}
import scala.jdk.CollectionConverters._
final case class GameSessionConnectionInfo(
    gameSessionArn: Option[ArnStringModel] = None,
    ipAddress: Option[StringModel] = None,
    dnsName: Option[DnsName] = None,
    port: Option[PositiveInteger] = None,
    matchedPlayerSessions: Option[
      Iterable[zio.aws.gamelift.model.MatchedPlayerSession]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.GameSessionConnectionInfo = {
    import GameSessionConnectionInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.GameSessionConnectionInfo
      .builder()
      .optionallyWith(
        gameSessionArn.map(value =>
          ArnStringModel.unwrap(value): java.lang.String
        )
      )(_.gameSessionArn)
      .optionallyWith(
        ipAddress.map(value => StringModel.unwrap(value): java.lang.String)
      )(_.ipAddress)
      .optionallyWith(
        dnsName.map(value => DnsName.unwrap(value): java.lang.String)
      )(_.dnsName)
      .optionallyWith(
        port.map(value => PositiveInteger.unwrap(value): Integer)
      )(_.port)
      .optionallyWith(
        matchedPlayerSessions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.matchedPlayerSessions)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.GameSessionConnectionInfo.ReadOnly =
    zio.aws.gamelift.model.GameSessionConnectionInfo.wrap(buildAwsValue())
}
object GameSessionConnectionInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.GameSessionConnectionInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.GameSessionConnectionInfo =
      zio.aws.gamelift.model.GameSessionConnectionInfo(
        gameSessionArn.map(value => value),
        ipAddress.map(value => value),
        dnsName.map(value => value),
        port.map(value => value),
        matchedPlayerSessions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def gameSessionArn: Option[ArnStringModel]
    def ipAddress: Option[StringModel]
    def dnsName: Option[DnsName]
    def port: Option[PositiveInteger]
    def matchedPlayerSessions
        : Option[List[zio.aws.gamelift.model.MatchedPlayerSession.ReadOnly]]
    def getGameSessionArn: ZIO[Any, AwsError, ArnStringModel] =
      AwsError.unwrapOptionField("gameSessionArn", gameSessionArn)
    def getIpAddress: ZIO[Any, AwsError, StringModel] =
      AwsError.unwrapOptionField("ipAddress", ipAddress)
    def getDnsName: ZIO[Any, AwsError, DnsName] =
      AwsError.unwrapOptionField("dnsName", dnsName)
    def getPort: ZIO[Any, AwsError, PositiveInteger] =
      AwsError.unwrapOptionField("port", port)
    def getMatchedPlayerSessions: ZIO[Any, AwsError, List[
      zio.aws.gamelift.model.MatchedPlayerSession.ReadOnly
    ]] =
      AwsError.unwrapOptionField("matchedPlayerSessions", matchedPlayerSessions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.GameSessionConnectionInfo
  ) extends zio.aws.gamelift.model.GameSessionConnectionInfo.ReadOnly {
    override val gameSessionArn: Option[ArnStringModel] = scala
      .Option(impl.gameSessionArn())
      .map(value => zio.aws.gamelift.model.primitives.ArnStringModel(value))
    override val ipAddress: Option[StringModel] = scala
      .Option(impl.ipAddress())
      .map(value => zio.aws.gamelift.model.primitives.StringModel(value))
    override val dnsName: Option[DnsName] = scala
      .Option(impl.dnsName())
      .map(value => zio.aws.gamelift.model.primitives.DnsName(value))
    override val port: Option[PositiveInteger] = scala
      .Option(impl.port())
      .map(value => zio.aws.gamelift.model.primitives.PositiveInteger(value))
    override val matchedPlayerSessions
        : Option[List[zio.aws.gamelift.model.MatchedPlayerSession.ReadOnly]] =
      scala
        .Option(impl.matchedPlayerSessions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.gamelift.model.MatchedPlayerSession.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.GameSessionConnectionInfo
  ): zio.aws.gamelift.model.GameSessionConnectionInfo.ReadOnly = new Wrapper(
    impl
  )
}
