package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GameSessionDetail(
    gameSession: Option[zio.aws.gamelift.model.GameSession] = None,
    protectionPolicy: Option[zio.aws.gamelift.model.ProtectionPolicy] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.GameSessionDetail = {
    import GameSessionDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.GameSessionDetail
      .builder()
      .optionallyWith(gameSession.map(value => value.buildAwsValue()))(
        _.gameSession
      )
      .optionallyWith(protectionPolicy.map(value => value.unwrap))(
        _.protectionPolicy
      )
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.GameSessionDetail.ReadOnly =
    zio.aws.gamelift.model.GameSessionDetail.wrap(buildAwsValue())
}
object GameSessionDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.GameSessionDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.GameSessionDetail =
      zio.aws.gamelift.model.GameSessionDetail(
        gameSession.map(value => value.asEditable),
        protectionPolicy.map(value => value)
      )
    def gameSession: Option[zio.aws.gamelift.model.GameSession.ReadOnly]
    def protectionPolicy: Option[zio.aws.gamelift.model.ProtectionPolicy]
    def getGameSession
        : ZIO[Any, AwsError, zio.aws.gamelift.model.GameSession.ReadOnly] =
      AwsError.unwrapOptionField("gameSession", gameSession)
    def getProtectionPolicy
        : ZIO[Any, AwsError, zio.aws.gamelift.model.ProtectionPolicy] =
      AwsError.unwrapOptionField("protectionPolicy", protectionPolicy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.GameSessionDetail
  ) extends zio.aws.gamelift.model.GameSessionDetail.ReadOnly {
    override val gameSession
        : Option[zio.aws.gamelift.model.GameSession.ReadOnly] = scala
      .Option(impl.gameSession())
      .map(value => zio.aws.gamelift.model.GameSession.wrap(value))
    override val protectionPolicy
        : Option[zio.aws.gamelift.model.ProtectionPolicy] = scala
      .Option(impl.protectionPolicy())
      .map(value => zio.aws.gamelift.model.ProtectionPolicy.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.GameSessionDetail
  ): zio.aws.gamelift.model.GameSessionDetail.ReadOnly = new Wrapper(impl)
}
