package zio.aws.gamelift.model
import zio.aws.gamelift.model.primitives.{
  DnsName,
  PortNumber,
  MatchmakerData,
  GameSessionQueueName,
  WholeNumber,
  Timestamp,
  IpAddress,
  IdStringModel,
  LargeGameSessionData,
  NonZeroAndMaxString
}
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GameSessionPlacement(
    placementId: Option[IdStringModel] = None,
    gameSessionQueueName: Option[GameSessionQueueName] = None,
    status: Option[zio.aws.gamelift.model.GameSessionPlacementState] = None,
    gameProperties: Option[Iterable[zio.aws.gamelift.model.GameProperty]] =
      None,
    maximumPlayerSessionCount: Option[WholeNumber] = None,
    gameSessionName: Option[NonZeroAndMaxString] = None,
    gameSessionId: Option[NonZeroAndMaxString] = None,
    gameSessionArn: Option[NonZeroAndMaxString] = None,
    gameSessionRegion: Option[NonZeroAndMaxString] = None,
    playerLatencies: Option[Iterable[zio.aws.gamelift.model.PlayerLatency]] =
      None,
    startTime: Option[Timestamp] = None,
    endTime: Option[Timestamp] = None,
    ipAddress: Option[IpAddress] = None,
    dnsName: Option[DnsName] = None,
    port: Option[PortNumber] = None,
    placedPlayerSessions: Option[
      Iterable[zio.aws.gamelift.model.PlacedPlayerSession]
    ] = None,
    gameSessionData: Option[LargeGameSessionData] = None,
    matchmakerData: Option[MatchmakerData] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.GameSessionPlacement = {
    import GameSessionPlacement.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.GameSessionPlacement
      .builder()
      .optionallyWith(
        placementId.map(value => IdStringModel.unwrap(value): java.lang.String)
      )(_.placementId)
      .optionallyWith(
        gameSessionQueueName.map(value =>
          GameSessionQueueName.unwrap(value): java.lang.String
        )
      )(_.gameSessionQueueName)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        gameProperties.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.gameProperties)
      .optionallyWith(
        maximumPlayerSessionCount.map(value =>
          WholeNumber.unwrap(value): Integer
        )
      )(_.maximumPlayerSessionCount)
      .optionallyWith(
        gameSessionName.map(value =>
          NonZeroAndMaxString.unwrap(value): java.lang.String
        )
      )(_.gameSessionName)
      .optionallyWith(
        gameSessionId.map(value =>
          NonZeroAndMaxString.unwrap(value): java.lang.String
        )
      )(_.gameSessionId)
      .optionallyWith(
        gameSessionArn.map(value =>
          NonZeroAndMaxString.unwrap(value): java.lang.String
        )
      )(_.gameSessionArn)
      .optionallyWith(
        gameSessionRegion.map(value =>
          NonZeroAndMaxString.unwrap(value): java.lang.String
        )
      )(_.gameSessionRegion)
      .optionallyWith(
        playerLatencies.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.playerLatencies)
      .optionallyWith(startTime.map(value => Timestamp.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(endTime.map(value => Timestamp.unwrap(value): Instant))(
        _.endTime
      )
      .optionallyWith(
        ipAddress.map(value => IpAddress.unwrap(value): java.lang.String)
      )(_.ipAddress)
      .optionallyWith(
        dnsName.map(value => DnsName.unwrap(value): java.lang.String)
      )(_.dnsName)
      .optionallyWith(port.map(value => PortNumber.unwrap(value): Integer))(
        _.port
      )
      .optionallyWith(
        placedPlayerSessions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.placedPlayerSessions)
      .optionallyWith(
        gameSessionData.map(value =>
          LargeGameSessionData.unwrap(value): java.lang.String
        )
      )(_.gameSessionData)
      .optionallyWith(
        matchmakerData.map(value =>
          MatchmakerData.unwrap(value): java.lang.String
        )
      )(_.matchmakerData)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.GameSessionPlacement.ReadOnly =
    zio.aws.gamelift.model.GameSessionPlacement.wrap(buildAwsValue())
}
object GameSessionPlacement {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.GameSessionPlacement
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.GameSessionPlacement =
      zio.aws.gamelift.model.GameSessionPlacement(
        placementId.map(value => value),
        gameSessionQueueName.map(value => value),
        status.map(value => value),
        gameProperties.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maximumPlayerSessionCount.map(value => value),
        gameSessionName.map(value => value),
        gameSessionId.map(value => value),
        gameSessionArn.map(value => value),
        gameSessionRegion.map(value => value),
        playerLatencies.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        startTime.map(value => value),
        endTime.map(value => value),
        ipAddress.map(value => value),
        dnsName.map(value => value),
        port.map(value => value),
        placedPlayerSessions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        gameSessionData.map(value => value),
        matchmakerData.map(value => value)
      )
    def placementId: Option[IdStringModel]
    def gameSessionQueueName: Option[GameSessionQueueName]
    def status: Option[zio.aws.gamelift.model.GameSessionPlacementState]
    def gameProperties
        : Option[List[zio.aws.gamelift.model.GameProperty.ReadOnly]]
    def maximumPlayerSessionCount: Option[WholeNumber]
    def gameSessionName: Option[NonZeroAndMaxString]
    def gameSessionId: Option[NonZeroAndMaxString]
    def gameSessionArn: Option[NonZeroAndMaxString]
    def gameSessionRegion: Option[NonZeroAndMaxString]
    def playerLatencies
        : Option[List[zio.aws.gamelift.model.PlayerLatency.ReadOnly]]
    def startTime: Option[Timestamp]
    def endTime: Option[Timestamp]
    def ipAddress: Option[IpAddress]
    def dnsName: Option[DnsName]
    def port: Option[PortNumber]
    def placedPlayerSessions
        : Option[List[zio.aws.gamelift.model.PlacedPlayerSession.ReadOnly]]
    def gameSessionData: Option[LargeGameSessionData]
    def matchmakerData: Option[MatchmakerData]
    def getPlacementId: ZIO[Any, AwsError, IdStringModel] =
      AwsError.unwrapOptionField("placementId", placementId)
    def getGameSessionQueueName: ZIO[Any, AwsError, GameSessionQueueName] =
      AwsError.unwrapOptionField("gameSessionQueueName", gameSessionQueueName)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.gamelift.model.GameSessionPlacementState] =
      AwsError.unwrapOptionField("status", status)
    def getGameProperties: ZIO[Any, AwsError, List[
      zio.aws.gamelift.model.GameProperty.ReadOnly
    ]] = AwsError.unwrapOptionField("gameProperties", gameProperties)
    def getMaximumPlayerSessionCount: ZIO[Any, AwsError, WholeNumber] = AwsError
      .unwrapOptionField("maximumPlayerSessionCount", maximumPlayerSessionCount)
    def getGameSessionName: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("gameSessionName", gameSessionName)
    def getGameSessionId: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("gameSessionId", gameSessionId)
    def getGameSessionArn: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("gameSessionArn", gameSessionArn)
    def getGameSessionRegion: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("gameSessionRegion", gameSessionRegion)
    def getPlayerLatencies: ZIO[Any, AwsError, List[
      zio.aws.gamelift.model.PlayerLatency.ReadOnly
    ]] = AwsError.unwrapOptionField("playerLatencies", playerLatencies)
    def getStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getIpAddress: ZIO[Any, AwsError, IpAddress] =
      AwsError.unwrapOptionField("ipAddress", ipAddress)
    def getDnsName: ZIO[Any, AwsError, DnsName] =
      AwsError.unwrapOptionField("dnsName", dnsName)
    def getPort: ZIO[Any, AwsError, PortNumber] =
      AwsError.unwrapOptionField("port", port)
    def getPlacedPlayerSessions: ZIO[Any, AwsError, List[
      zio.aws.gamelift.model.PlacedPlayerSession.ReadOnly
    ]] =
      AwsError.unwrapOptionField("placedPlayerSessions", placedPlayerSessions)
    def getGameSessionData: ZIO[Any, AwsError, LargeGameSessionData] =
      AwsError.unwrapOptionField("gameSessionData", gameSessionData)
    def getMatchmakerData: ZIO[Any, AwsError, MatchmakerData] =
      AwsError.unwrapOptionField("matchmakerData", matchmakerData)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.GameSessionPlacement
  ) extends zio.aws.gamelift.model.GameSessionPlacement.ReadOnly {
    override val placementId: Option[IdStringModel] = scala
      .Option(impl.placementId())
      .map(value => zio.aws.gamelift.model.primitives.IdStringModel(value))
    override val gameSessionQueueName: Option[GameSessionQueueName] = scala
      .Option(impl.gameSessionQueueName())
      .map(value =>
        zio.aws.gamelift.model.primitives.GameSessionQueueName(value)
      )
    override val status
        : Option[zio.aws.gamelift.model.GameSessionPlacementState] = scala
      .Option(impl.status())
      .map(value =>
        zio.aws.gamelift.model.GameSessionPlacementState.wrap(value)
      )
    override val gameProperties
        : Option[List[zio.aws.gamelift.model.GameProperty.ReadOnly]] = scala
      .Option(impl.gameProperties())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.gamelift.model.GameProperty.wrap(item)
        }.toList
      )
    override val maximumPlayerSessionCount: Option[WholeNumber] = scala
      .Option(impl.maximumPlayerSessionCount())
      .map(value => zio.aws.gamelift.model.primitives.WholeNumber(value))
    override val gameSessionName: Option[NonZeroAndMaxString] = scala
      .Option(impl.gameSessionName())
      .map(value =>
        zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
      )
    override val gameSessionId: Option[NonZeroAndMaxString] = scala
      .Option(impl.gameSessionId())
      .map(value =>
        zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
      )
    override val gameSessionArn: Option[NonZeroAndMaxString] = scala
      .Option(impl.gameSessionArn())
      .map(value =>
        zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
      )
    override val gameSessionRegion: Option[NonZeroAndMaxString] = scala
      .Option(impl.gameSessionRegion())
      .map(value =>
        zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
      )
    override val playerLatencies
        : Option[List[zio.aws.gamelift.model.PlayerLatency.ReadOnly]] = scala
      .Option(impl.playerLatencies())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.gamelift.model.PlayerLatency.wrap(item)
        }.toList
      )
    override val startTime: Option[Timestamp] = scala
      .Option(impl.startTime())
      .map(value => zio.aws.gamelift.model.primitives.Timestamp(value))
    override val endTime: Option[Timestamp] = scala
      .Option(impl.endTime())
      .map(value => zio.aws.gamelift.model.primitives.Timestamp(value))
    override val ipAddress: Option[IpAddress] = scala
      .Option(impl.ipAddress())
      .map(value => zio.aws.gamelift.model.primitives.IpAddress(value))
    override val dnsName: Option[DnsName] = scala
      .Option(impl.dnsName())
      .map(value => zio.aws.gamelift.model.primitives.DnsName(value))
    override val port: Option[PortNumber] = scala
      .Option(impl.port())
      .map(value => zio.aws.gamelift.model.primitives.PortNumber(value))
    override val placedPlayerSessions
        : Option[List[zio.aws.gamelift.model.PlacedPlayerSession.ReadOnly]] =
      scala
        .Option(impl.placedPlayerSessions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.gamelift.model.PlacedPlayerSession.wrap(item)
          }.toList
        )
    override val gameSessionData: Option[LargeGameSessionData] = scala
      .Option(impl.gameSessionData())
      .map(value =>
        zio.aws.gamelift.model.primitives.LargeGameSessionData(value)
      )
    override val matchmakerData: Option[MatchmakerData] = scala
      .Option(impl.matchmakerData())
      .map(value => zio.aws.gamelift.model.primitives.MatchmakerData(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.GameSessionPlacement
  ): zio.aws.gamelift.model.GameSessionPlacement.ReadOnly = new Wrapper(impl)
}
