package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.gamelift.model.primitives.{InstanceId, FleetIdOrArn}
import scala.jdk.CollectionConverters._
final case class GetInstanceAccessRequest(
    fleetId: FleetIdOrArn,
    instanceId: InstanceId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.GetInstanceAccessRequest = {
    import GetInstanceAccessRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.GetInstanceAccessRequest
      .builder()
      .fleetId(FleetIdOrArn.unwrap(fleetId): java.lang.String)
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.GetInstanceAccessRequest.ReadOnly =
    zio.aws.gamelift.model.GetInstanceAccessRequest.wrap(buildAwsValue())
}
object GetInstanceAccessRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.GetInstanceAccessRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.GetInstanceAccessRequest =
      zio.aws.gamelift.model.GetInstanceAccessRequest(fleetId, instanceId)
    def fleetId: FleetIdOrArn
    def instanceId: InstanceId
    def getFleetId: ZIO[Any, Nothing, FleetIdOrArn] = ZIO.succeed(fleetId)
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.GetInstanceAccessRequest
  ) extends zio.aws.gamelift.model.GetInstanceAccessRequest.ReadOnly {
    override val fleetId: FleetIdOrArn =
      zio.aws.gamelift.model.primitives.FleetIdOrArn(impl.fleetId())
    override val instanceId: InstanceId =
      zio.aws.gamelift.model.primitives.InstanceId(impl.instanceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.GetInstanceAccessRequest
  ): zio.aws.gamelift.model.GetInstanceAccessRequest.ReadOnly = new Wrapper(
    impl
  )
}
