package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetInstanceAccessResponse(
    instanceAccess: Option[zio.aws.gamelift.model.InstanceAccess] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.GetInstanceAccessResponse = {
    import GetInstanceAccessResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.GetInstanceAccessResponse
      .builder()
      .optionallyWith(instanceAccess.map(value => value.buildAwsValue()))(
        _.instanceAccess
      )
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.GetInstanceAccessResponse.ReadOnly =
    zio.aws.gamelift.model.GetInstanceAccessResponse.wrap(buildAwsValue())
}
object GetInstanceAccessResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.GetInstanceAccessResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.GetInstanceAccessResponse =
      zio.aws.gamelift.model.GetInstanceAccessResponse(
        instanceAccess.map(value => value.asEditable)
      )
    def instanceAccess: Option[zio.aws.gamelift.model.InstanceAccess.ReadOnly]
    def getInstanceAccess
        : ZIO[Any, AwsError, zio.aws.gamelift.model.InstanceAccess.ReadOnly] =
      AwsError.unwrapOptionField("instanceAccess", instanceAccess)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.GetInstanceAccessResponse
  ) extends zio.aws.gamelift.model.GetInstanceAccessResponse.ReadOnly {
    override val instanceAccess
        : Option[zio.aws.gamelift.model.InstanceAccess.ReadOnly] = scala
      .Option(impl.instanceAccess())
      .map(value => zio.aws.gamelift.model.InstanceAccess.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.GetInstanceAccessResponse
  ): zio.aws.gamelift.model.GetInstanceAccessResponse.ReadOnly = new Wrapper(
    impl
  )
}
