package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.gamelift.model.primitives.{
  DnsName,
  FleetId,
  FleetArn,
  InstanceId,
  Timestamp,
  LocationStringModel,
  IpAddress
}
import scala.jdk.CollectionConverters._
final case class Instance(
    fleetId: Option[FleetId] = None,
    fleetArn: Option[FleetArn] = None,
    instanceId: Option[InstanceId] = None,
    ipAddress: Option[IpAddress] = None,
    dnsName: Option[DnsName] = None,
    operatingSystem: Option[zio.aws.gamelift.model.OperatingSystem] = None,
    `type`: Option[zio.aws.gamelift.model.EC2InstanceType] = None,
    status: Option[zio.aws.gamelift.model.InstanceStatus] = None,
    creationTime: Option[Timestamp] = None,
    location: Option[LocationStringModel] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.Instance = {
    import Instance.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.Instance
      .builder()
      .optionallyWith(
        fleetId.map(value => FleetId.unwrap(value): java.lang.String)
      )(_.fleetId)
      .optionallyWith(
        fleetArn.map(value => FleetArn.unwrap(value): java.lang.String)
      )(_.fleetArn)
      .optionallyWith(
        instanceId.map(value => InstanceId.unwrap(value): java.lang.String)
      )(_.instanceId)
      .optionallyWith(
        ipAddress.map(value => IpAddress.unwrap(value): java.lang.String)
      )(_.ipAddress)
      .optionallyWith(
        dnsName.map(value => DnsName.unwrap(value): java.lang.String)
      )(_.dnsName)
      .optionallyWith(operatingSystem.map(value => value.unwrap))(
        _.operatingSystem
      )
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        location.map(value =>
          LocationStringModel.unwrap(value): java.lang.String
        )
      )(_.location)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.Instance.ReadOnly =
    zio.aws.gamelift.model.Instance.wrap(buildAwsValue())
}
object Instance {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.gamelift.model.Instance] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.Instance =
      zio.aws.gamelift.model.Instance(
        fleetId.map(value => value),
        fleetArn.map(value => value),
        instanceId.map(value => value),
        ipAddress.map(value => value),
        dnsName.map(value => value),
        operatingSystem.map(value => value),
        `type`.map(value => value),
        status.map(value => value),
        creationTime.map(value => value),
        location.map(value => value)
      )
    def fleetId: Option[FleetId]
    def fleetArn: Option[FleetArn]
    def instanceId: Option[InstanceId]
    def ipAddress: Option[IpAddress]
    def dnsName: Option[DnsName]
    def operatingSystem: Option[zio.aws.gamelift.model.OperatingSystem]
    def `type`: Option[zio.aws.gamelift.model.EC2InstanceType]
    def status: Option[zio.aws.gamelift.model.InstanceStatus]
    def creationTime: Option[Timestamp]
    def location: Option[LocationStringModel]
    def getFleetId: ZIO[Any, AwsError, FleetId] =
      AwsError.unwrapOptionField("fleetId", fleetId)
    def getFleetArn: ZIO[Any, AwsError, FleetArn] =
      AwsError.unwrapOptionField("fleetArn", fleetArn)
    def getInstanceId: ZIO[Any, AwsError, InstanceId] =
      AwsError.unwrapOptionField("instanceId", instanceId)
    def getIpAddress: ZIO[Any, AwsError, IpAddress] =
      AwsError.unwrapOptionField("ipAddress", ipAddress)
    def getDnsName: ZIO[Any, AwsError, DnsName] =
      AwsError.unwrapOptionField("dnsName", dnsName)
    def getOperatingSystem
        : ZIO[Any, AwsError, zio.aws.gamelift.model.OperatingSystem] =
      AwsError.unwrapOptionField("operatingSystem", operatingSystem)
    def getType: ZIO[Any, AwsError, zio.aws.gamelift.model.EC2InstanceType] =
      AwsError.unwrapOptionField("type", `type`)
    def getStatus: ZIO[Any, AwsError, zio.aws.gamelift.model.InstanceStatus] =
      AwsError.unwrapOptionField("status", status)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLocation: ZIO[Any, AwsError, LocationStringModel] =
      AwsError.unwrapOptionField("location", location)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.Instance
  ) extends zio.aws.gamelift.model.Instance.ReadOnly {
    override val fleetId: Option[FleetId] = scala
      .Option(impl.fleetId())
      .map(value => zio.aws.gamelift.model.primitives.FleetId(value))
    override val fleetArn: Option[FleetArn] = scala
      .Option(impl.fleetArn())
      .map(value => zio.aws.gamelift.model.primitives.FleetArn(value))
    override val instanceId: Option[InstanceId] = scala
      .Option(impl.instanceId())
      .map(value => zio.aws.gamelift.model.primitives.InstanceId(value))
    override val ipAddress: Option[IpAddress] = scala
      .Option(impl.ipAddress())
      .map(value => zio.aws.gamelift.model.primitives.IpAddress(value))
    override val dnsName: Option[DnsName] = scala
      .Option(impl.dnsName())
      .map(value => zio.aws.gamelift.model.primitives.DnsName(value))
    override val operatingSystem
        : Option[zio.aws.gamelift.model.OperatingSystem] = scala
      .Option(impl.operatingSystem())
      .map(value => zio.aws.gamelift.model.OperatingSystem.wrap(value))
    override val `type`: Option[zio.aws.gamelift.model.EC2InstanceType] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.gamelift.model.EC2InstanceType.wrap(value))
    override val status: Option[zio.aws.gamelift.model.InstanceStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.gamelift.model.InstanceStatus.wrap(value))
    override val creationTime: Option[Timestamp] = scala
      .Option(impl.creationTime())
      .map(value => zio.aws.gamelift.model.primitives.Timestamp(value))
    override val location: Option[LocationStringModel] = scala
      .Option(impl.location())
      .map(value =>
        zio.aws.gamelift.model.primitives.LocationStringModel(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.Instance
  ): zio.aws.gamelift.model.Instance.ReadOnly = new Wrapper(impl)
}
