package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.gamelift.model.primitives.{IpAddress, InstanceId, FleetId}
import scala.jdk.CollectionConverters._
final case class InstanceAccess(
    fleetId: Option[FleetId] = None,
    instanceId: Option[InstanceId] = None,
    ipAddress: Option[IpAddress] = None,
    operatingSystem: Option[zio.aws.gamelift.model.OperatingSystem] = None,
    credentials: Option[zio.aws.gamelift.model.InstanceCredentials] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.InstanceAccess = {
    import InstanceAccess.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.InstanceAccess
      .builder()
      .optionallyWith(
        fleetId.map(value => FleetId.unwrap(value): java.lang.String)
      )(_.fleetId)
      .optionallyWith(
        instanceId.map(value => InstanceId.unwrap(value): java.lang.String)
      )(_.instanceId)
      .optionallyWith(
        ipAddress.map(value => IpAddress.unwrap(value): java.lang.String)
      )(_.ipAddress)
      .optionallyWith(operatingSystem.map(value => value.unwrap))(
        _.operatingSystem
      )
      .optionallyWith(credentials.map(value => value.buildAwsValue()))(
        _.credentials
      )
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.InstanceAccess.ReadOnly =
    zio.aws.gamelift.model.InstanceAccess.wrap(buildAwsValue())
}
object InstanceAccess {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.InstanceAccess
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.InstanceAccess =
      zio.aws.gamelift.model.InstanceAccess(
        fleetId.map(value => value),
        instanceId.map(value => value),
        ipAddress.map(value => value),
        operatingSystem.map(value => value),
        credentials.map(value => value.asEditable)
      )
    def fleetId: Option[FleetId]
    def instanceId: Option[InstanceId]
    def ipAddress: Option[IpAddress]
    def operatingSystem: Option[zio.aws.gamelift.model.OperatingSystem]
    def credentials: Option[zio.aws.gamelift.model.InstanceCredentials.ReadOnly]
    def getFleetId: ZIO[Any, AwsError, FleetId] =
      AwsError.unwrapOptionField("fleetId", fleetId)
    def getInstanceId: ZIO[Any, AwsError, InstanceId] =
      AwsError.unwrapOptionField("instanceId", instanceId)
    def getIpAddress: ZIO[Any, AwsError, IpAddress] =
      AwsError.unwrapOptionField("ipAddress", ipAddress)
    def getOperatingSystem
        : ZIO[Any, AwsError, zio.aws.gamelift.model.OperatingSystem] =
      AwsError.unwrapOptionField("operatingSystem", operatingSystem)
    def getCredentials: ZIO[
      Any,
      AwsError,
      zio.aws.gamelift.model.InstanceCredentials.ReadOnly
    ] = AwsError.unwrapOptionField("credentials", credentials)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.InstanceAccess
  ) extends zio.aws.gamelift.model.InstanceAccess.ReadOnly {
    override val fleetId: Option[FleetId] = scala
      .Option(impl.fleetId())
      .map(value => zio.aws.gamelift.model.primitives.FleetId(value))
    override val instanceId: Option[InstanceId] = scala
      .Option(impl.instanceId())
      .map(value => zio.aws.gamelift.model.primitives.InstanceId(value))
    override val ipAddress: Option[IpAddress] = scala
      .Option(impl.ipAddress())
      .map(value => zio.aws.gamelift.model.primitives.IpAddress(value))
    override val operatingSystem
        : Option[zio.aws.gamelift.model.OperatingSystem] = scala
      .Option(impl.operatingSystem())
      .map(value => zio.aws.gamelift.model.OperatingSystem.wrap(value))
    override val credentials
        : Option[zio.aws.gamelift.model.InstanceCredentials.ReadOnly] = scala
      .Option(impl.credentials())
      .map(value => zio.aws.gamelift.model.InstanceCredentials.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.InstanceAccess
  ): zio.aws.gamelift.model.InstanceAccess.ReadOnly = new Wrapper(impl)
}
