package zio.aws.gamelift.model
import scala.jdk.CollectionConverters._
sealed trait IpProtocol {
  def unwrap: software.amazon.awssdk.services.gamelift.model.IpProtocol
}
object IpProtocol {
  def wrap(
      value: software.amazon.awssdk.services.gamelift.model.IpProtocol
  ): zio.aws.gamelift.model.IpProtocol = value match {
    case software.amazon.awssdk.services.gamelift.model.IpProtocol.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.gamelift.model.IpProtocol.TCP =>
      val r = TCP
      r
    case software.amazon.awssdk.services.gamelift.model.IpProtocol.UDP =>
      val r = UDP
      r
  }
  case object unknownToSdkVersion extends zio.aws.gamelift.model.IpProtocol {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.IpProtocol =
      software.amazon.awssdk.services.gamelift.model.IpProtocol.UNKNOWN_TO_SDK_VERSION
  }
  case object TCP extends zio.aws.gamelift.model.IpProtocol {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.IpProtocol =
      software.amazon.awssdk.services.gamelift.model.IpProtocol.TCP
  }
  case object UDP extends zio.aws.gamelift.model.IpProtocol {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.IpProtocol =
      software.amazon.awssdk.services.gamelift.model.IpProtocol.UDP
  }
}
