package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.gamelift.model.primitives.{
  LaunchTemplateVersion,
  LaunchTemplateName,
  LaunchTemplateId
}
import scala.jdk.CollectionConverters._
final case class LaunchTemplateSpecification(
    launchTemplateId: Option[LaunchTemplateId] = None,
    launchTemplateName: Option[LaunchTemplateName] = None,
    version: Option[LaunchTemplateVersion] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.LaunchTemplateSpecification = {
    import LaunchTemplateSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.LaunchTemplateSpecification
      .builder()
      .optionallyWith(
        launchTemplateId.map(value =>
          LaunchTemplateId.unwrap(value): java.lang.String
        )
      )(_.launchTemplateId)
      .optionallyWith(
        launchTemplateName.map(value =>
          LaunchTemplateName.unwrap(value): java.lang.String
        )
      )(_.launchTemplateName)
      .optionallyWith(
        version.map(value =>
          LaunchTemplateVersion.unwrap(value): java.lang.String
        )
      )(_.version)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.LaunchTemplateSpecification.ReadOnly =
    zio.aws.gamelift.model.LaunchTemplateSpecification.wrap(buildAwsValue())
}
object LaunchTemplateSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.LaunchTemplateSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.LaunchTemplateSpecification =
      zio.aws.gamelift.model.LaunchTemplateSpecification(
        launchTemplateId.map(value => value),
        launchTemplateName.map(value => value),
        version.map(value => value)
      )
    def launchTemplateId: Option[LaunchTemplateId]
    def launchTemplateName: Option[LaunchTemplateName]
    def version: Option[LaunchTemplateVersion]
    def getLaunchTemplateId: ZIO[Any, AwsError, LaunchTemplateId] =
      AwsError.unwrapOptionField("launchTemplateId", launchTemplateId)
    def getLaunchTemplateName: ZIO[Any, AwsError, LaunchTemplateName] =
      AwsError.unwrapOptionField("launchTemplateName", launchTemplateName)
    def getVersion: ZIO[Any, AwsError, LaunchTemplateVersion] =
      AwsError.unwrapOptionField("version", version)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.LaunchTemplateSpecification
  ) extends zio.aws.gamelift.model.LaunchTemplateSpecification.ReadOnly {
    override val launchTemplateId: Option[LaunchTemplateId] = scala
      .Option(impl.launchTemplateId())
      .map(value => zio.aws.gamelift.model.primitives.LaunchTemplateId(value))
    override val launchTemplateName: Option[LaunchTemplateName] = scala
      .Option(impl.launchTemplateName())
      .map(value => zio.aws.gamelift.model.primitives.LaunchTemplateName(value))
    override val version: Option[LaunchTemplateVersion] = scala
      .Option(impl.version())
      .map(value =>
        zio.aws.gamelift.model.primitives.LaunchTemplateVersion(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.LaunchTemplateSpecification
  ): zio.aws.gamelift.model.LaunchTemplateSpecification.ReadOnly = new Wrapper(
    impl
  )
}
