package zio.aws.gamelift.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.gamelift.model.primitives.{PositiveInteger, NonEmptyString}
import scala.jdk.CollectionConverters._
final case class ListAliasesRequest(
    routingStrategyType: Option[zio.aws.gamelift.model.RoutingStrategyType] =
      None,
    name: Option[NonEmptyString] = None,
    limit: Option[PositiveInteger] = None,
    nextToken: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.ListAliasesRequest = {
    import ListAliasesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.ListAliasesRequest
      .builder()
      .optionallyWith(routingStrategyType.map(value => value.unwrap))(
        _.routingStrategyType
      )
      .optionallyWith(
        name.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        limit.map(value => PositiveInteger.unwrap(value): Integer)
      )(_.limit)
      .optionallyWith(
        nextToken.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.ListAliasesRequest.ReadOnly =
    zio.aws.gamelift.model.ListAliasesRequest.wrap(buildAwsValue())
}
object ListAliasesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.ListAliasesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.ListAliasesRequest =
      zio.aws.gamelift.model.ListAliasesRequest(
        routingStrategyType.map(value => value),
        name.map(value => value),
        limit.map(value => value),
        nextToken.map(value => value)
      )
    def routingStrategyType: Option[zio.aws.gamelift.model.RoutingStrategyType]
    def name: Option[NonEmptyString]
    def limit: Option[PositiveInteger]
    def nextToken: Option[NonEmptyString]
    def getRoutingStrategyType
        : ZIO[Any, AwsError, zio.aws.gamelift.model.RoutingStrategyType] =
      AwsError.unwrapOptionField("routingStrategyType", routingStrategyType)
    def getName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("name", name)
    def getLimit: ZIO[Any, AwsError, PositiveInteger] =
      AwsError.unwrapOptionField("limit", limit)
    def getNextToken: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.ListAliasesRequest
  ) extends zio.aws.gamelift.model.ListAliasesRequest.ReadOnly {
    override val routingStrategyType
        : Option[zio.aws.gamelift.model.RoutingStrategyType] = scala
      .Option(impl.routingStrategyType())
      .map(value => zio.aws.gamelift.model.RoutingStrategyType.wrap(value))
    override val name: Option[NonEmptyString] = scala
      .Option(impl.name())
      .map(value => zio.aws.gamelift.model.primitives.NonEmptyString(value))
    override val limit: Option[PositiveInteger] = scala
      .Option(impl.limit())
      .map(value => zio.aws.gamelift.model.primitives.PositiveInteger(value))
    override val nextToken: Option[NonEmptyString] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.gamelift.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.ListAliasesRequest
  ): zio.aws.gamelift.model.ListAliasesRequest.ReadOnly = new Wrapper(impl)
}
