package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.gamelift.model.primitives.NonEmptyString
import scala.jdk.CollectionConverters._
final case class ListAliasesResponse(
    aliases: Option[Iterable[zio.aws.gamelift.model.Alias]] = None,
    nextToken: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.ListAliasesResponse = {
    import ListAliasesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.ListAliasesResponse
      .builder()
      .optionallyWith(
        aliases.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.aliases)
      .optionallyWith(
        nextToken.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.ListAliasesResponse.ReadOnly =
    zio.aws.gamelift.model.ListAliasesResponse.wrap(buildAwsValue())
}
object ListAliasesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.ListAliasesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.ListAliasesResponse =
      zio.aws.gamelift.model.ListAliasesResponse(
        aliases.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def aliases: Option[List[zio.aws.gamelift.model.Alias.ReadOnly]]
    def nextToken: Option[NonEmptyString]
    def getAliases
        : ZIO[Any, AwsError, List[zio.aws.gamelift.model.Alias.ReadOnly]] =
      AwsError.unwrapOptionField("aliases", aliases)
    def getNextToken: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.ListAliasesResponse
  ) extends zio.aws.gamelift.model.ListAliasesResponse.ReadOnly {
    override val aliases: Option[List[zio.aws.gamelift.model.Alias.ReadOnly]] =
      scala
        .Option(impl.aliases())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.gamelift.model.Alias.wrap(item)
          }.toList
        )
    override val nextToken: Option[NonEmptyString] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.gamelift.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.ListAliasesResponse
  ): zio.aws.gamelift.model.ListAliasesResponse.ReadOnly = new Wrapper(impl)
}
