package zio.aws.gamelift.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.gamelift.model.primitives.{NonEmptyString, PositiveInteger}
import scala.jdk.CollectionConverters._
final case class ListBuildsRequest(
    status: Option[zio.aws.gamelift.model.BuildStatus] = None,
    limit: Option[PositiveInteger] = None,
    nextToken: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.ListBuildsRequest = {
    import ListBuildsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.ListBuildsRequest
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        limit.map(value => PositiveInteger.unwrap(value): Integer)
      )(_.limit)
      .optionallyWith(
        nextToken.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.ListBuildsRequest.ReadOnly =
    zio.aws.gamelift.model.ListBuildsRequest.wrap(buildAwsValue())
}
object ListBuildsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.ListBuildsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.ListBuildsRequest =
      zio.aws.gamelift.model.ListBuildsRequest(
        status.map(value => value),
        limit.map(value => value),
        nextToken.map(value => value)
      )
    def status: Option[zio.aws.gamelift.model.BuildStatus]
    def limit: Option[PositiveInteger]
    def nextToken: Option[NonEmptyString]
    def getStatus: ZIO[Any, AwsError, zio.aws.gamelift.model.BuildStatus] =
      AwsError.unwrapOptionField("status", status)
    def getLimit: ZIO[Any, AwsError, PositiveInteger] =
      AwsError.unwrapOptionField("limit", limit)
    def getNextToken: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.ListBuildsRequest
  ) extends zio.aws.gamelift.model.ListBuildsRequest.ReadOnly {
    override val status: Option[zio.aws.gamelift.model.BuildStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.gamelift.model.BuildStatus.wrap(value))
    override val limit: Option[PositiveInteger] = scala
      .Option(impl.limit())
      .map(value => zio.aws.gamelift.model.primitives.PositiveInteger(value))
    override val nextToken: Option[NonEmptyString] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.gamelift.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.ListBuildsRequest
  ): zio.aws.gamelift.model.ListBuildsRequest.ReadOnly = new Wrapper(impl)
}
