package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.gamelift.model.primitives.NonEmptyString
import scala.jdk.CollectionConverters._
final case class ListBuildsResponse(
    builds: Option[Iterable[zio.aws.gamelift.model.Build]] = None,
    nextToken: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.ListBuildsResponse = {
    import ListBuildsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.ListBuildsResponse
      .builder()
      .optionallyWith(
        builds.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.builds)
      .optionallyWith(
        nextToken.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.ListBuildsResponse.ReadOnly =
    zio.aws.gamelift.model.ListBuildsResponse.wrap(buildAwsValue())
}
object ListBuildsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.ListBuildsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.ListBuildsResponse =
      zio.aws.gamelift.model.ListBuildsResponse(
        builds.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def builds: Option[List[zio.aws.gamelift.model.Build.ReadOnly]]
    def nextToken: Option[NonEmptyString]
    def getBuilds
        : ZIO[Any, AwsError, List[zio.aws.gamelift.model.Build.ReadOnly]] =
      AwsError.unwrapOptionField("builds", builds)
    def getNextToken: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.ListBuildsResponse
  ) extends zio.aws.gamelift.model.ListBuildsResponse.ReadOnly {
    override val builds: Option[List[zio.aws.gamelift.model.Build.ReadOnly]] =
      scala
        .Option(impl.builds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.gamelift.model.Build.wrap(item)
          }.toList
        )
    override val nextToken: Option[NonEmptyString] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.gamelift.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.ListBuildsResponse
  ): zio.aws.gamelift.model.ListBuildsResponse.ReadOnly = new Wrapper(impl)
}
