package zio.aws.gamelift.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.gamelift.model.primitives.{
  NonZeroAndMaxString,
  PositiveInteger,
  ScriptIdOrArn,
  BuildIdOrArn
}
import scala.jdk.CollectionConverters._
final case class ListFleetsRequest(
    buildId: Option[BuildIdOrArn] = None,
    scriptId: Option[ScriptIdOrArn] = None,
    limit: Option[PositiveInteger] = None,
    nextToken: Option[NonZeroAndMaxString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.ListFleetsRequest = {
    import ListFleetsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.ListFleetsRequest
      .builder()
      .optionallyWith(
        buildId.map(value => BuildIdOrArn.unwrap(value): java.lang.String)
      )(_.buildId)
      .optionallyWith(
        scriptId.map(value => ScriptIdOrArn.unwrap(value): java.lang.String)
      )(_.scriptId)
      .optionallyWith(
        limit.map(value => PositiveInteger.unwrap(value): Integer)
      )(_.limit)
      .optionallyWith(
        nextToken.map(value =>
          NonZeroAndMaxString.unwrap(value): java.lang.String
        )
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.ListFleetsRequest.ReadOnly =
    zio.aws.gamelift.model.ListFleetsRequest.wrap(buildAwsValue())
}
object ListFleetsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.ListFleetsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.ListFleetsRequest =
      zio.aws.gamelift.model.ListFleetsRequest(
        buildId.map(value => value),
        scriptId.map(value => value),
        limit.map(value => value),
        nextToken.map(value => value)
      )
    def buildId: Option[BuildIdOrArn]
    def scriptId: Option[ScriptIdOrArn]
    def limit: Option[PositiveInteger]
    def nextToken: Option[NonZeroAndMaxString]
    def getBuildId: ZIO[Any, AwsError, BuildIdOrArn] =
      AwsError.unwrapOptionField("buildId", buildId)
    def getScriptId: ZIO[Any, AwsError, ScriptIdOrArn] =
      AwsError.unwrapOptionField("scriptId", scriptId)
    def getLimit: ZIO[Any, AwsError, PositiveInteger] =
      AwsError.unwrapOptionField("limit", limit)
    def getNextToken: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.ListFleetsRequest
  ) extends zio.aws.gamelift.model.ListFleetsRequest.ReadOnly {
    override val buildId: Option[BuildIdOrArn] = scala
      .Option(impl.buildId())
      .map(value => zio.aws.gamelift.model.primitives.BuildIdOrArn(value))
    override val scriptId: Option[ScriptIdOrArn] = scala
      .Option(impl.scriptId())
      .map(value => zio.aws.gamelift.model.primitives.ScriptIdOrArn(value))
    override val limit: Option[PositiveInteger] = scala
      .Option(impl.limit())
      .map(value => zio.aws.gamelift.model.primitives.PositiveInteger(value))
    override val nextToken: Option[NonZeroAndMaxString] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.ListFleetsRequest
  ): zio.aws.gamelift.model.ListFleetsRequest.ReadOnly = new Wrapper(impl)
}
