package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.gamelift.model.primitives.{NonZeroAndMaxString, FleetId}
import scala.jdk.CollectionConverters._
final case class ListFleetsResponse(
    fleetIds: Option[Iterable[FleetId]] = None,
    nextToken: Option[NonZeroAndMaxString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.ListFleetsResponse = {
    import ListFleetsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.ListFleetsResponse
      .builder()
      .optionallyWith(
        fleetIds.map(value =>
          value.map { item =>
            FleetId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.fleetIds)
      .optionallyWith(
        nextToken.map(value =>
          NonZeroAndMaxString.unwrap(value): java.lang.String
        )
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.ListFleetsResponse.ReadOnly =
    zio.aws.gamelift.model.ListFleetsResponse.wrap(buildAwsValue())
}
object ListFleetsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.ListFleetsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.ListFleetsResponse =
      zio.aws.gamelift.model.ListFleetsResponse(
        fleetIds.map(value => value),
        nextToken.map(value => value)
      )
    def fleetIds: Option[List[FleetId]]
    def nextToken: Option[NonZeroAndMaxString]
    def getFleetIds: ZIO[Any, AwsError, List[FleetId]] =
      AwsError.unwrapOptionField("fleetIds", fleetIds)
    def getNextToken: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.ListFleetsResponse
  ) extends zio.aws.gamelift.model.ListFleetsResponse.ReadOnly {
    override val fleetIds: Option[List[FleetId]] = scala
      .Option(impl.fleetIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.gamelift.model.primitives.FleetId(item)
        }.toList
      )
    override val nextToken: Option[NonZeroAndMaxString] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.ListFleetsResponse
  ): zio.aws.gamelift.model.ListFleetsResponse.ReadOnly = new Wrapper(impl)
}
