package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.gamelift.model.primitives.NonZeroAndMaxString
import scala.jdk.CollectionConverters._
final case class ListGameServerGroupsResponse(
    gameServerGroups: Option[Iterable[zio.aws.gamelift.model.GameServerGroup]] =
      None,
    nextToken: Option[NonZeroAndMaxString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.ListGameServerGroupsResponse = {
    import ListGameServerGroupsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.ListGameServerGroupsResponse
      .builder()
      .optionallyWith(
        gameServerGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.gameServerGroups)
      .optionallyWith(
        nextToken.map(value =>
          NonZeroAndMaxString.unwrap(value): java.lang.String
        )
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.ListGameServerGroupsResponse.ReadOnly =
    zio.aws.gamelift.model.ListGameServerGroupsResponse.wrap(buildAwsValue())
}
object ListGameServerGroupsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.ListGameServerGroupsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.ListGameServerGroupsResponse =
      zio.aws.gamelift.model.ListGameServerGroupsResponse(
        gameServerGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def gameServerGroups
        : Option[List[zio.aws.gamelift.model.GameServerGroup.ReadOnly]]
    def nextToken: Option[NonZeroAndMaxString]
    def getGameServerGroups: ZIO[Any, AwsError, List[
      zio.aws.gamelift.model.GameServerGroup.ReadOnly
    ]] = AwsError.unwrapOptionField("gameServerGroups", gameServerGroups)
    def getNextToken: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.ListGameServerGroupsResponse
  ) extends zio.aws.gamelift.model.ListGameServerGroupsResponse.ReadOnly {
    override val gameServerGroups
        : Option[List[zio.aws.gamelift.model.GameServerGroup.ReadOnly]] = scala
      .Option(impl.gameServerGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.gamelift.model.GameServerGroup.wrap(item)
        }.toList
      )
    override val nextToken: Option[NonZeroAndMaxString] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.ListGameServerGroupsResponse
  ): zio.aws.gamelift.model.ListGameServerGroupsResponse.ReadOnly = new Wrapper(
    impl
  )
}
