package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.gamelift.model.primitives.NonZeroAndMaxString
import scala.jdk.CollectionConverters._
final case class ListGameServersResponse(
    gameServers: Option[Iterable[zio.aws.gamelift.model.GameServer]] = None,
    nextToken: Option[NonZeroAndMaxString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.ListGameServersResponse = {
    import ListGameServersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.ListGameServersResponse
      .builder()
      .optionallyWith(
        gameServers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.gameServers)
      .optionallyWith(
        nextToken.map(value =>
          NonZeroAndMaxString.unwrap(value): java.lang.String
        )
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.ListGameServersResponse.ReadOnly =
    zio.aws.gamelift.model.ListGameServersResponse.wrap(buildAwsValue())
}
object ListGameServersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.ListGameServersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.ListGameServersResponse =
      zio.aws.gamelift.model.ListGameServersResponse(
        gameServers.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def gameServers: Option[List[zio.aws.gamelift.model.GameServer.ReadOnly]]
    def nextToken: Option[NonZeroAndMaxString]
    def getGameServers
        : ZIO[Any, AwsError, List[zio.aws.gamelift.model.GameServer.ReadOnly]] =
      AwsError.unwrapOptionField("gameServers", gameServers)
    def getNextToken: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.ListGameServersResponse
  ) extends zio.aws.gamelift.model.ListGameServersResponse.ReadOnly {
    override val gameServers
        : Option[List[zio.aws.gamelift.model.GameServer.ReadOnly]] = scala
      .Option(impl.gameServers())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.gamelift.model.GameServer.wrap(item)
        }.toList
      )
    override val nextToken: Option[NonZeroAndMaxString] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.ListGameServersResponse
  ): zio.aws.gamelift.model.ListGameServersResponse.ReadOnly = new Wrapper(impl)
}
