package zio.aws.gamelift.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.gamelift.model.primitives.{NonEmptyString, PositiveInteger}
import scala.jdk.CollectionConverters._
final case class ListScriptsRequest(
    limit: Option[PositiveInteger] = None,
    nextToken: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.ListScriptsRequest = {
    import ListScriptsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.ListScriptsRequest
      .builder()
      .optionallyWith(
        limit.map(value => PositiveInteger.unwrap(value): Integer)
      )(_.limit)
      .optionallyWith(
        nextToken.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.ListScriptsRequest.ReadOnly =
    zio.aws.gamelift.model.ListScriptsRequest.wrap(buildAwsValue())
}
object ListScriptsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.ListScriptsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.ListScriptsRequest =
      zio.aws.gamelift.model.ListScriptsRequest(
        limit.map(value => value),
        nextToken.map(value => value)
      )
    def limit: Option[PositiveInteger]
    def nextToken: Option[NonEmptyString]
    def getLimit: ZIO[Any, AwsError, PositiveInteger] =
      AwsError.unwrapOptionField("limit", limit)
    def getNextToken: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.ListScriptsRequest
  ) extends zio.aws.gamelift.model.ListScriptsRequest.ReadOnly {
    override val limit: Option[PositiveInteger] = scala
      .Option(impl.limit())
      .map(value => zio.aws.gamelift.model.primitives.PositiveInteger(value))
    override val nextToken: Option[NonEmptyString] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.gamelift.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.ListScriptsRequest
  ): zio.aws.gamelift.model.ListScriptsRequest.ReadOnly = new Wrapper(impl)
}
