package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.gamelift.model.primitives.NonEmptyString
import scala.jdk.CollectionConverters._
final case class ListScriptsResponse(
    scripts: Option[Iterable[zio.aws.gamelift.model.Script]] = None,
    nextToken: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.ListScriptsResponse = {
    import ListScriptsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.ListScriptsResponse
      .builder()
      .optionallyWith(
        scripts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.scripts)
      .optionallyWith(
        nextToken.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.ListScriptsResponse.ReadOnly =
    zio.aws.gamelift.model.ListScriptsResponse.wrap(buildAwsValue())
}
object ListScriptsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.ListScriptsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.ListScriptsResponse =
      zio.aws.gamelift.model.ListScriptsResponse(
        scripts.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def scripts: Option[List[zio.aws.gamelift.model.Script.ReadOnly]]
    def nextToken: Option[NonEmptyString]
    def getScripts
        : ZIO[Any, AwsError, List[zio.aws.gamelift.model.Script.ReadOnly]] =
      AwsError.unwrapOptionField("scripts", scripts)
    def getNextToken: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.ListScriptsResponse
  ) extends zio.aws.gamelift.model.ListScriptsResponse.ReadOnly {
    override val scripts: Option[List[zio.aws.gamelift.model.Script.ReadOnly]] =
      scala
        .Option(impl.scripts())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.gamelift.model.Script.wrap(item)
          }.toList
        )
    override val nextToken: Option[NonEmptyString] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.gamelift.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.ListScriptsResponse
  ): zio.aws.gamelift.model.ListScriptsResponse.ReadOnly = new Wrapper(impl)
}
