package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class LocationAttributes(
    locationState: Option[zio.aws.gamelift.model.LocationState] = None,
    stoppedActions: Option[Iterable[zio.aws.gamelift.model.FleetAction]] = None,
    updateStatus: Option[zio.aws.gamelift.model.LocationUpdateStatus] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.LocationAttributes = {
    import LocationAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.LocationAttributes
      .builder()
      .optionallyWith(locationState.map(value => value.buildAwsValue()))(
        _.locationState
      )
      .optionallyWith(
        stoppedActions.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.stoppedActionsWithStrings)
      .optionallyWith(updateStatus.map(value => value.unwrap))(_.updateStatus)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.LocationAttributes.ReadOnly =
    zio.aws.gamelift.model.LocationAttributes.wrap(buildAwsValue())
}
object LocationAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.LocationAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.LocationAttributes =
      zio.aws.gamelift.model.LocationAttributes(
        locationState.map(value => value.asEditable),
        stoppedActions.map(value => value),
        updateStatus.map(value => value)
      )
    def locationState: Option[zio.aws.gamelift.model.LocationState.ReadOnly]
    def stoppedActions: Option[List[zio.aws.gamelift.model.FleetAction]]
    def updateStatus: Option[zio.aws.gamelift.model.LocationUpdateStatus]
    def getLocationState
        : ZIO[Any, AwsError, zio.aws.gamelift.model.LocationState.ReadOnly] =
      AwsError.unwrapOptionField("locationState", locationState)
    def getStoppedActions
        : ZIO[Any, AwsError, List[zio.aws.gamelift.model.FleetAction]] =
      AwsError.unwrapOptionField("stoppedActions", stoppedActions)
    def getUpdateStatus
        : ZIO[Any, AwsError, zio.aws.gamelift.model.LocationUpdateStatus] =
      AwsError.unwrapOptionField("updateStatus", updateStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.LocationAttributes
  ) extends zio.aws.gamelift.model.LocationAttributes.ReadOnly {
    override val locationState
        : Option[zio.aws.gamelift.model.LocationState.ReadOnly] = scala
      .Option(impl.locationState())
      .map(value => zio.aws.gamelift.model.LocationState.wrap(value))
    override val stoppedActions
        : Option[List[zio.aws.gamelift.model.FleetAction]] = scala
      .Option(impl.stoppedActions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.gamelift.model.FleetAction.wrap(item)
        }.toList
      )
    override val updateStatus
        : Option[zio.aws.gamelift.model.LocationUpdateStatus] = scala
      .Option(impl.updateStatus())
      .map(value => zio.aws.gamelift.model.LocationUpdateStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.LocationAttributes
  ): zio.aws.gamelift.model.LocationAttributes.ReadOnly = new Wrapper(impl)
}
