package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.gamelift.model.primitives.LocationStringModel
import scala.jdk.CollectionConverters._
final case class LocationConfiguration(
    location: Option[LocationStringModel] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.LocationConfiguration = {
    import LocationConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.LocationConfiguration
      .builder()
      .optionallyWith(
        location.map(value =>
          LocationStringModel.unwrap(value): java.lang.String
        )
      )(_.location)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.LocationConfiguration.ReadOnly =
    zio.aws.gamelift.model.LocationConfiguration.wrap(buildAwsValue())
}
object LocationConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.LocationConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.LocationConfiguration =
      zio.aws.gamelift.model.LocationConfiguration(location.map(value => value))
    def location: Option[LocationStringModel]
    def getLocation: ZIO[Any, AwsError, LocationStringModel] =
      AwsError.unwrapOptionField("location", location)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.LocationConfiguration
  ) extends zio.aws.gamelift.model.LocationConfiguration.ReadOnly {
    override val location: Option[LocationStringModel] = scala
      .Option(impl.location())
      .map(value =>
        zio.aws.gamelift.model.primitives.LocationStringModel(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.LocationConfiguration
  ): zio.aws.gamelift.model.LocationConfiguration.ReadOnly = new Wrapper(impl)
}
