package zio.aws.gamelift.model
import zio.aws.gamelift.model.primitives.{
  ArnStringModel,
  SnsArnStringModel,
  CustomEventData,
  WholeNumber,
  Timestamp,
  MatchmakingAcceptanceTimeoutInteger,
  BooleanModel,
  MatchmakingRuleSetArn,
  GameSessionData,
  NonZeroAndMaxString,
  MatchmakingRequestTimeoutInteger,
  MatchmakingConfigurationArn,
  MatchmakingIdStringModel
}
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class MatchmakingConfiguration(
    name: Option[MatchmakingIdStringModel] = None,
    configurationArn: Option[MatchmakingConfigurationArn] = None,
    description: Option[NonZeroAndMaxString] = None,
    gameSessionQueueArns: Option[Iterable[ArnStringModel]] = None,
    requestTimeoutSeconds: Option[MatchmakingRequestTimeoutInteger] = None,
    acceptanceTimeoutSeconds: Option[MatchmakingAcceptanceTimeoutInteger] =
      None,
    acceptanceRequired: Option[BooleanModel] = None,
    ruleSetName: Option[MatchmakingIdStringModel] = None,
    ruleSetArn: Option[MatchmakingRuleSetArn] = None,
    notificationTarget: Option[SnsArnStringModel] = None,
    additionalPlayerCount: Option[WholeNumber] = None,
    customEventData: Option[CustomEventData] = None,
    creationTime: Option[Timestamp] = None,
    gameProperties: Option[Iterable[zio.aws.gamelift.model.GameProperty]] =
      None,
    gameSessionData: Option[GameSessionData] = None,
    backfillMode: Option[zio.aws.gamelift.model.BackfillMode] = None,
    flexMatchMode: Option[zio.aws.gamelift.model.FlexMatchMode] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.MatchmakingConfiguration = {
    import MatchmakingConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.MatchmakingConfiguration
      .builder()
      .optionallyWith(
        name.map(value =>
          MatchmakingIdStringModel.unwrap(value): java.lang.String
        )
      )(_.name)
      .optionallyWith(
        configurationArn.map(value =>
          MatchmakingConfigurationArn.unwrap(value): java.lang.String
        )
      )(_.configurationArn)
      .optionallyWith(
        description.map(value =>
          NonZeroAndMaxString.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        gameSessionQueueArns.map(value =>
          value.map { item =>
            ArnStringModel.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.gameSessionQueueArns)
      .optionallyWith(
        requestTimeoutSeconds.map(value =>
          MatchmakingRequestTimeoutInteger.unwrap(value): Integer
        )
      )(_.requestTimeoutSeconds)
      .optionallyWith(
        acceptanceTimeoutSeconds.map(value =>
          MatchmakingAcceptanceTimeoutInteger.unwrap(value): Integer
        )
      )(_.acceptanceTimeoutSeconds)
      .optionallyWith(
        acceptanceRequired.map(value =>
          BooleanModel.unwrap(value): java.lang.Boolean
        )
      )(_.acceptanceRequired)
      .optionallyWith(
        ruleSetName.map(value =>
          MatchmakingIdStringModel.unwrap(value): java.lang.String
        )
      )(_.ruleSetName)
      .optionallyWith(
        ruleSetArn.map(value =>
          MatchmakingRuleSetArn.unwrap(value): java.lang.String
        )
      )(_.ruleSetArn)
      .optionallyWith(
        notificationTarget.map(value =>
          SnsArnStringModel.unwrap(value): java.lang.String
        )
      )(_.notificationTarget)
      .optionallyWith(
        additionalPlayerCount.map(value => WholeNumber.unwrap(value): Integer)
      )(_.additionalPlayerCount)
      .optionallyWith(
        customEventData.map(value =>
          CustomEventData.unwrap(value): java.lang.String
        )
      )(_.customEventData)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        gameProperties.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.gameProperties)
      .optionallyWith(
        gameSessionData.map(value =>
          GameSessionData.unwrap(value): java.lang.String
        )
      )(_.gameSessionData)
      .optionallyWith(backfillMode.map(value => value.unwrap))(_.backfillMode)
      .optionallyWith(flexMatchMode.map(value => value.unwrap))(_.flexMatchMode)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.MatchmakingConfiguration.ReadOnly =
    zio.aws.gamelift.model.MatchmakingConfiguration.wrap(buildAwsValue())
}
object MatchmakingConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.MatchmakingConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.MatchmakingConfiguration =
      zio.aws.gamelift.model.MatchmakingConfiguration(
        name.map(value => value),
        configurationArn.map(value => value),
        description.map(value => value),
        gameSessionQueueArns.map(value => value),
        requestTimeoutSeconds.map(value => value),
        acceptanceTimeoutSeconds.map(value => value),
        acceptanceRequired.map(value => value),
        ruleSetName.map(value => value),
        ruleSetArn.map(value => value),
        notificationTarget.map(value => value),
        additionalPlayerCount.map(value => value),
        customEventData.map(value => value),
        creationTime.map(value => value),
        gameProperties.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        gameSessionData.map(value => value),
        backfillMode.map(value => value),
        flexMatchMode.map(value => value)
      )
    def name: Option[MatchmakingIdStringModel]
    def configurationArn: Option[MatchmakingConfigurationArn]
    def description: Option[NonZeroAndMaxString]
    def gameSessionQueueArns: Option[List[ArnStringModel]]
    def requestTimeoutSeconds: Option[MatchmakingRequestTimeoutInteger]
    def acceptanceTimeoutSeconds: Option[MatchmakingAcceptanceTimeoutInteger]
    def acceptanceRequired: Option[BooleanModel]
    def ruleSetName: Option[MatchmakingIdStringModel]
    def ruleSetArn: Option[MatchmakingRuleSetArn]
    def notificationTarget: Option[SnsArnStringModel]
    def additionalPlayerCount: Option[WholeNumber]
    def customEventData: Option[CustomEventData]
    def creationTime: Option[Timestamp]
    def gameProperties
        : Option[List[zio.aws.gamelift.model.GameProperty.ReadOnly]]
    def gameSessionData: Option[GameSessionData]
    def backfillMode: Option[zio.aws.gamelift.model.BackfillMode]
    def flexMatchMode: Option[zio.aws.gamelift.model.FlexMatchMode]
    def getName: ZIO[Any, AwsError, MatchmakingIdStringModel] =
      AwsError.unwrapOptionField("name", name)
    def getConfigurationArn: ZIO[Any, AwsError, MatchmakingConfigurationArn] =
      AwsError.unwrapOptionField("configurationArn", configurationArn)
    def getDescription: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("description", description)
    def getGameSessionQueueArns: ZIO[Any, AwsError, List[ArnStringModel]] =
      AwsError.unwrapOptionField("gameSessionQueueArns", gameSessionQueueArns)
    def getRequestTimeoutSeconds
        : ZIO[Any, AwsError, MatchmakingRequestTimeoutInteger] =
      AwsError.unwrapOptionField("requestTimeoutSeconds", requestTimeoutSeconds)
    def getAcceptanceTimeoutSeconds
        : ZIO[Any, AwsError, MatchmakingAcceptanceTimeoutInteger] = AwsError
      .unwrapOptionField("acceptanceTimeoutSeconds", acceptanceTimeoutSeconds)
    def getAcceptanceRequired: ZIO[Any, AwsError, BooleanModel] =
      AwsError.unwrapOptionField("acceptanceRequired", acceptanceRequired)
    def getRuleSetName: ZIO[Any, AwsError, MatchmakingIdStringModel] =
      AwsError.unwrapOptionField("ruleSetName", ruleSetName)
    def getRuleSetArn: ZIO[Any, AwsError, MatchmakingRuleSetArn] =
      AwsError.unwrapOptionField("ruleSetArn", ruleSetArn)
    def getNotificationTarget: ZIO[Any, AwsError, SnsArnStringModel] =
      AwsError.unwrapOptionField("notificationTarget", notificationTarget)
    def getAdditionalPlayerCount: ZIO[Any, AwsError, WholeNumber] =
      AwsError.unwrapOptionField("additionalPlayerCount", additionalPlayerCount)
    def getCustomEventData: ZIO[Any, AwsError, CustomEventData] =
      AwsError.unwrapOptionField("customEventData", customEventData)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getGameProperties: ZIO[Any, AwsError, List[
      zio.aws.gamelift.model.GameProperty.ReadOnly
    ]] = AwsError.unwrapOptionField("gameProperties", gameProperties)
    def getGameSessionData: ZIO[Any, AwsError, GameSessionData] =
      AwsError.unwrapOptionField("gameSessionData", gameSessionData)
    def getBackfillMode
        : ZIO[Any, AwsError, zio.aws.gamelift.model.BackfillMode] =
      AwsError.unwrapOptionField("backfillMode", backfillMode)
    def getFlexMatchMode
        : ZIO[Any, AwsError, zio.aws.gamelift.model.FlexMatchMode] =
      AwsError.unwrapOptionField("flexMatchMode", flexMatchMode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.MatchmakingConfiguration
  ) extends zio.aws.gamelift.model.MatchmakingConfiguration.ReadOnly {
    override val name: Option[MatchmakingIdStringModel] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.gamelift.model.primitives.MatchmakingIdStringModel(value)
      )
    override val configurationArn: Option[MatchmakingConfigurationArn] = scala
      .Option(impl.configurationArn())
      .map(value =>
        zio.aws.gamelift.model.primitives.MatchmakingConfigurationArn(value)
      )
    override val description: Option[NonZeroAndMaxString] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
      )
    override val gameSessionQueueArns: Option[List[ArnStringModel]] = scala
      .Option(impl.gameSessionQueueArns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.gamelift.model.primitives.ArnStringModel(item)
        }.toList
      )
    override val requestTimeoutSeconds
        : Option[MatchmakingRequestTimeoutInteger] = scala
      .Option(impl.requestTimeoutSeconds())
      .map(value =>
        zio.aws.gamelift.model.primitives
          .MatchmakingRequestTimeoutInteger(value)
      )
    override val acceptanceTimeoutSeconds
        : Option[MatchmakingAcceptanceTimeoutInteger] = scala
      .Option(impl.acceptanceTimeoutSeconds())
      .map(value =>
        zio.aws.gamelift.model.primitives
          .MatchmakingAcceptanceTimeoutInteger(value)
      )
    override val acceptanceRequired: Option[BooleanModel] = scala
      .Option(impl.acceptanceRequired())
      .map(value => zio.aws.gamelift.model.primitives.BooleanModel(value))
    override val ruleSetName: Option[MatchmakingIdStringModel] = scala
      .Option(impl.ruleSetName())
      .map(value =>
        zio.aws.gamelift.model.primitives.MatchmakingIdStringModel(value)
      )
    override val ruleSetArn: Option[MatchmakingRuleSetArn] = scala
      .Option(impl.ruleSetArn())
      .map(value =>
        zio.aws.gamelift.model.primitives.MatchmakingRuleSetArn(value)
      )
    override val notificationTarget: Option[SnsArnStringModel] = scala
      .Option(impl.notificationTarget())
      .map(value => zio.aws.gamelift.model.primitives.SnsArnStringModel(value))
    override val additionalPlayerCount: Option[WholeNumber] = scala
      .Option(impl.additionalPlayerCount())
      .map(value => zio.aws.gamelift.model.primitives.WholeNumber(value))
    override val customEventData: Option[CustomEventData] = scala
      .Option(impl.customEventData())
      .map(value => zio.aws.gamelift.model.primitives.CustomEventData(value))
    override val creationTime: Option[Timestamp] = scala
      .Option(impl.creationTime())
      .map(value => zio.aws.gamelift.model.primitives.Timestamp(value))
    override val gameProperties
        : Option[List[zio.aws.gamelift.model.GameProperty.ReadOnly]] = scala
      .Option(impl.gameProperties())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.gamelift.model.GameProperty.wrap(item)
        }.toList
      )
    override val gameSessionData: Option[GameSessionData] = scala
      .Option(impl.gameSessionData())
      .map(value => zio.aws.gamelift.model.primitives.GameSessionData(value))
    override val backfillMode: Option[zio.aws.gamelift.model.BackfillMode] =
      scala
        .Option(impl.backfillMode())
        .map(value => zio.aws.gamelift.model.BackfillMode.wrap(value))
    override val flexMatchMode: Option[zio.aws.gamelift.model.FlexMatchMode] =
      scala
        .Option(impl.flexMatchMode())
        .map(value => zio.aws.gamelift.model.FlexMatchMode.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.MatchmakingConfiguration
  ): zio.aws.gamelift.model.MatchmakingConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
