package zio.aws.gamelift.model
import zio.aws.gamelift.model.primitives.{
  StringModel,
  WholeNumber,
  Timestamp,
  MatchmakingConfigurationArn,
  MatchmakingIdStringModel
}
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class MatchmakingTicket(
    ticketId: Option[MatchmakingIdStringModel] = None,
    configurationName: Option[MatchmakingIdStringModel] = None,
    configurationArn: Option[MatchmakingConfigurationArn] = None,
    status: Option[zio.aws.gamelift.model.MatchmakingConfigurationStatus] =
      None,
    statusReason: Option[StringModel] = None,
    statusMessage: Option[StringModel] = None,
    startTime: Option[Timestamp] = None,
    endTime: Option[Timestamp] = None,
    players: Option[Iterable[zio.aws.gamelift.model.Player]] = None,
    gameSessionConnectionInfo: Option[
      zio.aws.gamelift.model.GameSessionConnectionInfo
    ] = None,
    estimatedWaitTime: Option[WholeNumber] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.MatchmakingTicket = {
    import MatchmakingTicket.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.MatchmakingTicket
      .builder()
      .optionallyWith(
        ticketId.map(value =>
          MatchmakingIdStringModel.unwrap(value): java.lang.String
        )
      )(_.ticketId)
      .optionallyWith(
        configurationName.map(value =>
          MatchmakingIdStringModel.unwrap(value): java.lang.String
        )
      )(_.configurationName)
      .optionallyWith(
        configurationArn.map(value =>
          MatchmakingConfigurationArn.unwrap(value): java.lang.String
        )
      )(_.configurationArn)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        statusReason.map(value => StringModel.unwrap(value): java.lang.String)
      )(_.statusReason)
      .optionallyWith(
        statusMessage.map(value => StringModel.unwrap(value): java.lang.String)
      )(_.statusMessage)
      .optionallyWith(startTime.map(value => Timestamp.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(endTime.map(value => Timestamp.unwrap(value): Instant))(
        _.endTime
      )
      .optionallyWith(
        players.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.players)
      .optionallyWith(
        gameSessionConnectionInfo.map(value => value.buildAwsValue())
      )(_.gameSessionConnectionInfo)
      .optionallyWith(
        estimatedWaitTime.map(value => WholeNumber.unwrap(value): Integer)
      )(_.estimatedWaitTime)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.MatchmakingTicket.ReadOnly =
    zio.aws.gamelift.model.MatchmakingTicket.wrap(buildAwsValue())
}
object MatchmakingTicket {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.MatchmakingTicket
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.MatchmakingTicket =
      zio.aws.gamelift.model.MatchmakingTicket(
        ticketId.map(value => value),
        configurationName.map(value => value),
        configurationArn.map(value => value),
        status.map(value => value),
        statusReason.map(value => value),
        statusMessage.map(value => value),
        startTime.map(value => value),
        endTime.map(value => value),
        players.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        gameSessionConnectionInfo.map(value => value.asEditable),
        estimatedWaitTime.map(value => value)
      )
    def ticketId: Option[MatchmakingIdStringModel]
    def configurationName: Option[MatchmakingIdStringModel]
    def configurationArn: Option[MatchmakingConfigurationArn]
    def status: Option[zio.aws.gamelift.model.MatchmakingConfigurationStatus]
    def statusReason: Option[StringModel]
    def statusMessage: Option[StringModel]
    def startTime: Option[Timestamp]
    def endTime: Option[Timestamp]
    def players: Option[List[zio.aws.gamelift.model.Player.ReadOnly]]
    def gameSessionConnectionInfo
        : Option[zio.aws.gamelift.model.GameSessionConnectionInfo.ReadOnly]
    def estimatedWaitTime: Option[WholeNumber]
    def getTicketId: ZIO[Any, AwsError, MatchmakingIdStringModel] =
      AwsError.unwrapOptionField("ticketId", ticketId)
    def getConfigurationName: ZIO[Any, AwsError, MatchmakingIdStringModel] =
      AwsError.unwrapOptionField("configurationName", configurationName)
    def getConfigurationArn: ZIO[Any, AwsError, MatchmakingConfigurationArn] =
      AwsError.unwrapOptionField("configurationArn", configurationArn)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.gamelift.model.MatchmakingConfigurationStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getStatusReason: ZIO[Any, AwsError, StringModel] =
      AwsError.unwrapOptionField("statusReason", statusReason)
    def getStatusMessage: ZIO[Any, AwsError, StringModel] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getPlayers
        : ZIO[Any, AwsError, List[zio.aws.gamelift.model.Player.ReadOnly]] =
      AwsError.unwrapOptionField("players", players)
    def getGameSessionConnectionInfo: ZIO[
      Any,
      AwsError,
      zio.aws.gamelift.model.GameSessionConnectionInfo.ReadOnly
    ] = AwsError.unwrapOptionField(
      "gameSessionConnectionInfo",
      gameSessionConnectionInfo
    )
    def getEstimatedWaitTime: ZIO[Any, AwsError, WholeNumber] =
      AwsError.unwrapOptionField("estimatedWaitTime", estimatedWaitTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.MatchmakingTicket
  ) extends zio.aws.gamelift.model.MatchmakingTicket.ReadOnly {
    override val ticketId: Option[MatchmakingIdStringModel] = scala
      .Option(impl.ticketId())
      .map(value =>
        zio.aws.gamelift.model.primitives.MatchmakingIdStringModel(value)
      )
    override val configurationName: Option[MatchmakingIdStringModel] = scala
      .Option(impl.configurationName())
      .map(value =>
        zio.aws.gamelift.model.primitives.MatchmakingIdStringModel(value)
      )
    override val configurationArn: Option[MatchmakingConfigurationArn] = scala
      .Option(impl.configurationArn())
      .map(value =>
        zio.aws.gamelift.model.primitives.MatchmakingConfigurationArn(value)
      )
    override val status
        : Option[zio.aws.gamelift.model.MatchmakingConfigurationStatus] = scala
      .Option(impl.status())
      .map(value =>
        zio.aws.gamelift.model.MatchmakingConfigurationStatus.wrap(value)
      )
    override val statusReason: Option[StringModel] = scala
      .Option(impl.statusReason())
      .map(value => zio.aws.gamelift.model.primitives.StringModel(value))
    override val statusMessage: Option[StringModel] = scala
      .Option(impl.statusMessage())
      .map(value => zio.aws.gamelift.model.primitives.StringModel(value))
    override val startTime: Option[Timestamp] = scala
      .Option(impl.startTime())
      .map(value => zio.aws.gamelift.model.primitives.Timestamp(value))
    override val endTime: Option[Timestamp] = scala
      .Option(impl.endTime())
      .map(value => zio.aws.gamelift.model.primitives.Timestamp(value))
    override val players: Option[List[zio.aws.gamelift.model.Player.ReadOnly]] =
      scala
        .Option(impl.players())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.gamelift.model.Player.wrap(item)
          }.toList
        )
    override val gameSessionConnectionInfo
        : Option[zio.aws.gamelift.model.GameSessionConnectionInfo.ReadOnly] =
      scala
        .Option(impl.gameSessionConnectionInfo())
        .map(value =>
          zio.aws.gamelift.model.GameSessionConnectionInfo.wrap(value)
        )
    override val estimatedWaitTime: Option[WholeNumber] = scala
      .Option(impl.estimatedWaitTime())
      .map(value => zio.aws.gamelift.model.primitives.WholeNumber(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.MatchmakingTicket
  ): zio.aws.gamelift.model.MatchmakingTicket.ReadOnly = new Wrapper(impl)
}
