package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.gamelift.model.primitives.NonZeroAndMaxString
import scala.jdk.CollectionConverters._
final case class PlayerLatency(
    playerId: Option[NonZeroAndMaxString] = None,
    regionIdentifier: Option[NonZeroAndMaxString] = None,
    latencyInMilliseconds: Option[Float] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.PlayerLatency = {
    import PlayerLatency.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.PlayerLatency
      .builder()
      .optionallyWith(
        playerId.map(value =>
          NonZeroAndMaxString.unwrap(value): java.lang.String
        )
      )(_.playerId)
      .optionallyWith(
        regionIdentifier.map(value =>
          NonZeroAndMaxString.unwrap(value): java.lang.String
        )
      )(_.regionIdentifier)
      .optionallyWith(
        latencyInMilliseconds.map(value => value: java.lang.Float)
      )(_.latencyInMilliseconds)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.PlayerLatency.ReadOnly =
    zio.aws.gamelift.model.PlayerLatency.wrap(buildAwsValue())
}
object PlayerLatency {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.PlayerLatency
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.PlayerLatency =
      zio.aws.gamelift.model.PlayerLatency(
        playerId.map(value => value),
        regionIdentifier.map(value => value),
        latencyInMilliseconds.map(value => value)
      )
    def playerId: Option[NonZeroAndMaxString]
    def regionIdentifier: Option[NonZeroAndMaxString]
    def latencyInMilliseconds: Option[Float]
    def getPlayerId: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("playerId", playerId)
    def getRegionIdentifier: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("regionIdentifier", regionIdentifier)
    def getLatencyInMilliseconds: ZIO[Any, AwsError, Float] =
      AwsError.unwrapOptionField("latencyInMilliseconds", latencyInMilliseconds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.PlayerLatency
  ) extends zio.aws.gamelift.model.PlayerLatency.ReadOnly {
    override val playerId: Option[NonZeroAndMaxString] = scala
      .Option(impl.playerId())
      .map(value =>
        zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
      )
    override val regionIdentifier: Option[NonZeroAndMaxString] = scala
      .Option(impl.regionIdentifier())
      .map(value =>
        zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
      )
    override val latencyInMilliseconds: Option[Float] =
      scala.Option(impl.latencyInMilliseconds()).map(value => value: Float)
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.PlayerLatency
  ): zio.aws.gamelift.model.PlayerLatency.ReadOnly = new Wrapper(impl)
}
