package zio.aws.gamelift.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.gamelift.model.primitives.WholeNumber
import scala.jdk.CollectionConverters._
final case class PlayerLatencyPolicy(
    maximumIndividualPlayerLatencyMilliseconds: Option[WholeNumber] = None,
    policyDurationSeconds: Option[WholeNumber] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.PlayerLatencyPolicy = {
    import PlayerLatencyPolicy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.PlayerLatencyPolicy
      .builder()
      .optionallyWith(
        maximumIndividualPlayerLatencyMilliseconds.map(value =>
          WholeNumber.unwrap(value): Integer
        )
      )(_.maximumIndividualPlayerLatencyMilliseconds)
      .optionallyWith(
        policyDurationSeconds.map(value => WholeNumber.unwrap(value): Integer)
      )(_.policyDurationSeconds)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.PlayerLatencyPolicy.ReadOnly =
    zio.aws.gamelift.model.PlayerLatencyPolicy.wrap(buildAwsValue())
}
object PlayerLatencyPolicy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.PlayerLatencyPolicy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.PlayerLatencyPolicy =
      zio.aws.gamelift.model.PlayerLatencyPolicy(
        maximumIndividualPlayerLatencyMilliseconds.map(value => value),
        policyDurationSeconds.map(value => value)
      )
    def maximumIndividualPlayerLatencyMilliseconds: Option[WholeNumber]
    def policyDurationSeconds: Option[WholeNumber]
    def getMaximumIndividualPlayerLatencyMilliseconds
        : ZIO[Any, AwsError, WholeNumber] = AwsError.unwrapOptionField(
      "maximumIndividualPlayerLatencyMilliseconds",
      maximumIndividualPlayerLatencyMilliseconds
    )
    def getPolicyDurationSeconds: ZIO[Any, AwsError, WholeNumber] =
      AwsError.unwrapOptionField("policyDurationSeconds", policyDurationSeconds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.PlayerLatencyPolicy
  ) extends zio.aws.gamelift.model.PlayerLatencyPolicy.ReadOnly {
    override val maximumIndividualPlayerLatencyMilliseconds
        : Option[WholeNumber] = scala
      .Option(impl.maximumIndividualPlayerLatencyMilliseconds())
      .map(value => zio.aws.gamelift.model.primitives.WholeNumber(value))
    override val policyDurationSeconds: Option[WholeNumber] = scala
      .Option(impl.policyDurationSeconds())
      .map(value => zio.aws.gamelift.model.primitives.WholeNumber(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.PlayerLatencyPolicy
  ): zio.aws.gamelift.model.PlayerLatencyPolicy.ReadOnly = new Wrapper(impl)
}
