package zio.aws.gamelift.model
import scala.jdk.CollectionConverters._
sealed trait PriorityType {
  def unwrap: software.amazon.awssdk.services.gamelift.model.PriorityType
}
object PriorityType {
  def wrap(
      value: software.amazon.awssdk.services.gamelift.model.PriorityType
  ): zio.aws.gamelift.model.PriorityType = value match {
    case software.amazon.awssdk.services.gamelift.model.PriorityType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.gamelift.model.PriorityType.LATENCY =>
      val r = LATENCY
      r
    case software.amazon.awssdk.services.gamelift.model.PriorityType.COST =>
      val r = COST
      r
    case software.amazon.awssdk.services.gamelift.model.PriorityType.DESTINATION =>
      val r = DESTINATION
      r
    case software.amazon.awssdk.services.gamelift.model.PriorityType.LOCATION =>
      val r = LOCATION
      r
  }
  case object unknownToSdkVersion extends zio.aws.gamelift.model.PriorityType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.PriorityType =
      software.amazon.awssdk.services.gamelift.model.PriorityType.UNKNOWN_TO_SDK_VERSION
  }
  case object LATENCY extends zio.aws.gamelift.model.PriorityType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.PriorityType =
      software.amazon.awssdk.services.gamelift.model.PriorityType.LATENCY
  }
  case object COST extends zio.aws.gamelift.model.PriorityType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.PriorityType =
      software.amazon.awssdk.services.gamelift.model.PriorityType.COST
  }
  case object DESTINATION extends zio.aws.gamelift.model.PriorityType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.PriorityType =
      software.amazon.awssdk.services.gamelift.model.PriorityType.DESTINATION
  }
  case object LOCATION extends zio.aws.gamelift.model.PriorityType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.PriorityType =
      software.amazon.awssdk.services.gamelift.model.PriorityType.LOCATION
  }
}
