package zio.aws.gamelift.model
import scala.jdk.CollectionConverters._
sealed trait ProtectionPolicy {
  def unwrap: software.amazon.awssdk.services.gamelift.model.ProtectionPolicy
}
object ProtectionPolicy {
  def wrap(
      value: software.amazon.awssdk.services.gamelift.model.ProtectionPolicy
  ): zio.aws.gamelift.model.ProtectionPolicy = value match {
    case software.amazon.awssdk.services.gamelift.model.ProtectionPolicy.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.gamelift.model.ProtectionPolicy.NO_PROTECTION =>
      val r = NoProtection
      r
    case software.amazon.awssdk.services.gamelift.model.ProtectionPolicy.FULL_PROTECTION =>
      val r = FullProtection
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.gamelift.model.ProtectionPolicy {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.ProtectionPolicy =
      software.amazon.awssdk.services.gamelift.model.ProtectionPolicy.UNKNOWN_TO_SDK_VERSION
  }
  case object NoProtection extends zio.aws.gamelift.model.ProtectionPolicy {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.ProtectionPolicy =
      software.amazon.awssdk.services.gamelift.model.ProtectionPolicy.NO_PROTECTION
  }
  case object FullProtection extends zio.aws.gamelift.model.ProtectionPolicy {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.ProtectionPolicy =
      software.amazon.awssdk.services.gamelift.model.ProtectionPolicy.FULL_PROTECTION
  }
}
