package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.gamelift.model.primitives.{
  PositiveInteger,
  Integer,
  FleetIdOrArn,
  NonZeroAndMaxString
}
import scala.jdk.CollectionConverters._
final case class PutScalingPolicyRequest(
    name: NonZeroAndMaxString,
    fleetId: FleetIdOrArn,
    scalingAdjustment: Option[Integer] = None,
    scalingAdjustmentType: Option[
      zio.aws.gamelift.model.ScalingAdjustmentType
    ] = None,
    threshold: Option[Double] = None,
    comparisonOperator: Option[zio.aws.gamelift.model.ComparisonOperatorType] =
      None,
    evaluationPeriods: Option[PositiveInteger] = None,
    metricName: zio.aws.gamelift.model.MetricName,
    policyType: Option[zio.aws.gamelift.model.PolicyType] = None,
    targetConfiguration: Option[zio.aws.gamelift.model.TargetConfiguration] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.PutScalingPolicyRequest = {
    import PutScalingPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.PutScalingPolicyRequest
      .builder()
      .name(NonZeroAndMaxString.unwrap(name): java.lang.String)
      .fleetId(FleetIdOrArn.unwrap(fleetId): java.lang.String)
      .optionallyWith(
        scalingAdjustment.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.scalingAdjustment)
      .optionallyWith(scalingAdjustmentType.map(value => value.unwrap))(
        _.scalingAdjustmentType
      )
      .optionallyWith(threshold.map(value => value: java.lang.Double))(
        _.threshold
      )
      .optionallyWith(comparisonOperator.map(value => value.unwrap))(
        _.comparisonOperator
      )
      .optionallyWith(
        evaluationPeriods.map(value =>
          PositiveInteger.unwrap(value): java.lang.Integer
        )
      )(_.evaluationPeriods)
      .metricName(metricName.unwrap)
      .optionallyWith(policyType.map(value => value.unwrap))(_.policyType)
      .optionallyWith(targetConfiguration.map(value => value.buildAwsValue()))(
        _.targetConfiguration
      )
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.PutScalingPolicyRequest.ReadOnly =
    zio.aws.gamelift.model.PutScalingPolicyRequest.wrap(buildAwsValue())
}
object PutScalingPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.PutScalingPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.PutScalingPolicyRequest =
      zio.aws.gamelift.model.PutScalingPolicyRequest(
        name,
        fleetId,
        scalingAdjustment.map(value => value),
        scalingAdjustmentType.map(value => value),
        threshold.map(value => value),
        comparisonOperator.map(value => value),
        evaluationPeriods.map(value => value),
        metricName,
        policyType.map(value => value),
        targetConfiguration.map(value => value.asEditable)
      )
    def name: NonZeroAndMaxString
    def fleetId: FleetIdOrArn
    def scalingAdjustment: Option[Integer]
    def scalingAdjustmentType
        : Option[zio.aws.gamelift.model.ScalingAdjustmentType]
    def threshold: Option[Double]
    def comparisonOperator
        : Option[zio.aws.gamelift.model.ComparisonOperatorType]
    def evaluationPeriods: Option[PositiveInteger]
    def metricName: zio.aws.gamelift.model.MetricName
    def policyType: Option[zio.aws.gamelift.model.PolicyType]
    def targetConfiguration
        : Option[zio.aws.gamelift.model.TargetConfiguration.ReadOnly]
    def getName: ZIO[Any, Nothing, NonZeroAndMaxString] = ZIO.succeed(name)
    def getFleetId: ZIO[Any, Nothing, FleetIdOrArn] = ZIO.succeed(fleetId)
    def getScalingAdjustment: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("scalingAdjustment", scalingAdjustment)
    def getScalingAdjustmentType
        : ZIO[Any, AwsError, zio.aws.gamelift.model.ScalingAdjustmentType] =
      AwsError.unwrapOptionField("scalingAdjustmentType", scalingAdjustmentType)
    def getThreshold: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("threshold", threshold)
    def getComparisonOperator
        : ZIO[Any, AwsError, zio.aws.gamelift.model.ComparisonOperatorType] =
      AwsError.unwrapOptionField("comparisonOperator", comparisonOperator)
    def getEvaluationPeriods: ZIO[Any, AwsError, PositiveInteger] =
      AwsError.unwrapOptionField("evaluationPeriods", evaluationPeriods)
    def getMetricName: ZIO[Any, Nothing, zio.aws.gamelift.model.MetricName] =
      ZIO.succeed(metricName)
    def getPolicyType: ZIO[Any, AwsError, zio.aws.gamelift.model.PolicyType] =
      AwsError.unwrapOptionField("policyType", policyType)
    def getTargetConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.gamelift.model.TargetConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("targetConfiguration", targetConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.PutScalingPolicyRequest
  ) extends zio.aws.gamelift.model.PutScalingPolicyRequest.ReadOnly {
    override val name: NonZeroAndMaxString =
      zio.aws.gamelift.model.primitives.NonZeroAndMaxString(impl.name())
    override val fleetId: FleetIdOrArn =
      zio.aws.gamelift.model.primitives.FleetIdOrArn(impl.fleetId())
    override val scalingAdjustment: Option[Integer] = scala
      .Option(impl.scalingAdjustment())
      .map(value => zio.aws.gamelift.model.primitives.Integer(value))
    override val scalingAdjustmentType
        : Option[zio.aws.gamelift.model.ScalingAdjustmentType] = scala
      .Option(impl.scalingAdjustmentType())
      .map(value => zio.aws.gamelift.model.ScalingAdjustmentType.wrap(value))
    override val threshold: Option[Double] =
      scala.Option(impl.threshold()).map(value => value: Double)
    override val comparisonOperator
        : Option[zio.aws.gamelift.model.ComparisonOperatorType] = scala
      .Option(impl.comparisonOperator())
      .map(value => zio.aws.gamelift.model.ComparisonOperatorType.wrap(value))
    override val evaluationPeriods: Option[PositiveInteger] = scala
      .Option(impl.evaluationPeriods())
      .map(value => zio.aws.gamelift.model.primitives.PositiveInteger(value))
    override val metricName: zio.aws.gamelift.model.MetricName =
      zio.aws.gamelift.model.MetricName.wrap(impl.metricName())
    override val policyType: Option[zio.aws.gamelift.model.PolicyType] = scala
      .Option(impl.policyType())
      .map(value => zio.aws.gamelift.model.PolicyType.wrap(value))
    override val targetConfiguration
        : Option[zio.aws.gamelift.model.TargetConfiguration.ReadOnly] = scala
      .Option(impl.targetConfiguration())
      .map(value => zio.aws.gamelift.model.TargetConfiguration.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.PutScalingPolicyRequest
  ): zio.aws.gamelift.model.PutScalingPolicyRequest.ReadOnly = new Wrapper(impl)
}
