package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.gamelift.model.primitives.{
  GameServerData,
  GameServerId,
  GameServerConnectionInfo,
  GameServerInstanceId,
  GameServerGroupNameOrArn
}
import scala.jdk.CollectionConverters._
final case class RegisterGameServerRequest(
    gameServerGroupName: GameServerGroupNameOrArn,
    gameServerId: GameServerId,
    instanceId: GameServerInstanceId,
    connectionInfo: Option[GameServerConnectionInfo] = None,
    gameServerData: Option[GameServerData] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.RegisterGameServerRequest = {
    import RegisterGameServerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.RegisterGameServerRequest
      .builder()
      .gameServerGroupName(
        GameServerGroupNameOrArn.unwrap(gameServerGroupName): java.lang.String
      )
      .gameServerId(GameServerId.unwrap(gameServerId): java.lang.String)
      .instanceId(GameServerInstanceId.unwrap(instanceId): java.lang.String)
      .optionallyWith(
        connectionInfo.map(value =>
          GameServerConnectionInfo.unwrap(value): java.lang.String
        )
      )(_.connectionInfo)
      .optionallyWith(
        gameServerData.map(value =>
          GameServerData.unwrap(value): java.lang.String
        )
      )(_.gameServerData)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.RegisterGameServerRequest.ReadOnly =
    zio.aws.gamelift.model.RegisterGameServerRequest.wrap(buildAwsValue())
}
object RegisterGameServerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.RegisterGameServerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.RegisterGameServerRequest =
      zio.aws.gamelift.model.RegisterGameServerRequest(
        gameServerGroupName,
        gameServerId,
        instanceId,
        connectionInfo.map(value => value),
        gameServerData.map(value => value)
      )
    def gameServerGroupName: GameServerGroupNameOrArn
    def gameServerId: GameServerId
    def instanceId: GameServerInstanceId
    def connectionInfo: Option[GameServerConnectionInfo]
    def gameServerData: Option[GameServerData]
    def getGameServerGroupName: ZIO[Any, Nothing, GameServerGroupNameOrArn] =
      ZIO.succeed(gameServerGroupName)
    def getGameServerId: ZIO[Any, Nothing, GameServerId] =
      ZIO.succeed(gameServerId)
    def getInstanceId: ZIO[Any, Nothing, GameServerInstanceId] =
      ZIO.succeed(instanceId)
    def getConnectionInfo: ZIO[Any, AwsError, GameServerConnectionInfo] =
      AwsError.unwrapOptionField("connectionInfo", connectionInfo)
    def getGameServerData: ZIO[Any, AwsError, GameServerData] =
      AwsError.unwrapOptionField("gameServerData", gameServerData)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.RegisterGameServerRequest
  ) extends zio.aws.gamelift.model.RegisterGameServerRequest.ReadOnly {
    override val gameServerGroupName: GameServerGroupNameOrArn =
      zio.aws.gamelift.model.primitives
        .GameServerGroupNameOrArn(impl.gameServerGroupName())
    override val gameServerId: GameServerId =
      zio.aws.gamelift.model.primitives.GameServerId(impl.gameServerId())
    override val instanceId: GameServerInstanceId =
      zio.aws.gamelift.model.primitives.GameServerInstanceId(impl.instanceId())
    override val connectionInfo: Option[GameServerConnectionInfo] = scala
      .Option(impl.connectionInfo())
      .map(value =>
        zio.aws.gamelift.model.primitives.GameServerConnectionInfo(value)
      )
    override val gameServerData: Option[GameServerData] = scala
      .Option(impl.gameServerData())
      .map(value => zio.aws.gamelift.model.primitives.GameServerData(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.RegisterGameServerRequest
  ): zio.aws.gamelift.model.RegisterGameServerRequest.ReadOnly = new Wrapper(
    impl
  )
}
