package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class RequestUploadCredentialsResponse(
    uploadCredentials: Option[zio.aws.gamelift.model.Credentials] = None,
    storageLocation: Option[zio.aws.gamelift.model.S3Location] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.RequestUploadCredentialsResponse = {
    import RequestUploadCredentialsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.RequestUploadCredentialsResponse
      .builder()
      .optionallyWith(uploadCredentials.map(value => value.buildAwsValue()))(
        _.uploadCredentials
      )
      .optionallyWith(storageLocation.map(value => value.buildAwsValue()))(
        _.storageLocation
      )
      .build()
  }
  def asReadOnly
      : zio.aws.gamelift.model.RequestUploadCredentialsResponse.ReadOnly =
    zio.aws.gamelift.model.RequestUploadCredentialsResponse
      .wrap(buildAwsValue())
}
object RequestUploadCredentialsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.RequestUploadCredentialsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.RequestUploadCredentialsResponse =
      zio.aws.gamelift.model.RequestUploadCredentialsResponse(
        uploadCredentials.map(value => value.asEditable),
        storageLocation.map(value => value.asEditable)
      )
    def uploadCredentials: Option[zio.aws.gamelift.model.Credentials.ReadOnly]
    def storageLocation: Option[zio.aws.gamelift.model.S3Location.ReadOnly]
    def getUploadCredentials
        : ZIO[Any, AwsError, zio.aws.gamelift.model.Credentials.ReadOnly] =
      AwsError.unwrapOptionField("uploadCredentials", uploadCredentials)
    def getStorageLocation
        : ZIO[Any, AwsError, zio.aws.gamelift.model.S3Location.ReadOnly] =
      AwsError.unwrapOptionField("storageLocation", storageLocation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.RequestUploadCredentialsResponse
  ) extends zio.aws.gamelift.model.RequestUploadCredentialsResponse.ReadOnly {
    override val uploadCredentials
        : Option[zio.aws.gamelift.model.Credentials.ReadOnly] = scala
      .Option(impl.uploadCredentials())
      .map(value => zio.aws.gamelift.model.Credentials.wrap(value))
    override val storageLocation
        : Option[zio.aws.gamelift.model.S3Location.ReadOnly] = scala
      .Option(impl.storageLocation())
      .map(value => zio.aws.gamelift.model.S3Location.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.RequestUploadCredentialsResponse
  ): zio.aws.gamelift.model.RequestUploadCredentialsResponse.ReadOnly =
    new Wrapper(impl)
}
