package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.gamelift.model.primitives.{FleetArn, FleetId}
import scala.jdk.CollectionConverters._
final case class ResolveAliasResponse(
    fleetId: Option[FleetId] = None,
    fleetArn: Option[FleetArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.ResolveAliasResponse = {
    import ResolveAliasResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.ResolveAliasResponse
      .builder()
      .optionallyWith(
        fleetId.map(value => FleetId.unwrap(value): java.lang.String)
      )(_.fleetId)
      .optionallyWith(
        fleetArn.map(value => FleetArn.unwrap(value): java.lang.String)
      )(_.fleetArn)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.ResolveAliasResponse.ReadOnly =
    zio.aws.gamelift.model.ResolveAliasResponse.wrap(buildAwsValue())
}
object ResolveAliasResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.ResolveAliasResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.ResolveAliasResponse =
      zio.aws.gamelift.model.ResolveAliasResponse(
        fleetId.map(value => value),
        fleetArn.map(value => value)
      )
    def fleetId: Option[FleetId]
    def fleetArn: Option[FleetArn]
    def getFleetId: ZIO[Any, AwsError, FleetId] =
      AwsError.unwrapOptionField("fleetId", fleetId)
    def getFleetArn: ZIO[Any, AwsError, FleetArn] =
      AwsError.unwrapOptionField("fleetArn", fleetArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.ResolveAliasResponse
  ) extends zio.aws.gamelift.model.ResolveAliasResponse.ReadOnly {
    override val fleetId: Option[FleetId] = scala
      .Option(impl.fleetId())
      .map(value => zio.aws.gamelift.model.primitives.FleetId(value))
    override val fleetArn: Option[FleetArn] = scala
      .Option(impl.fleetArn())
      .map(value => zio.aws.gamelift.model.primitives.FleetArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.ResolveAliasResponse
  ): zio.aws.gamelift.model.ResolveAliasResponse.ReadOnly = new Wrapper(impl)
}
