package zio.aws.gamelift.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.gamelift.model.primitives.WholeNumber
import scala.jdk.CollectionConverters._
final case class ResourceCreationLimitPolicy(
    newGameSessionsPerCreator: Option[WholeNumber] = None,
    policyPeriodInMinutes: Option[WholeNumber] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.ResourceCreationLimitPolicy = {
    import ResourceCreationLimitPolicy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.ResourceCreationLimitPolicy
      .builder()
      .optionallyWith(
        newGameSessionsPerCreator.map(value =>
          WholeNumber.unwrap(value): Integer
        )
      )(_.newGameSessionsPerCreator)
      .optionallyWith(
        policyPeriodInMinutes.map(value => WholeNumber.unwrap(value): Integer)
      )(_.policyPeriodInMinutes)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.ResourceCreationLimitPolicy.ReadOnly =
    zio.aws.gamelift.model.ResourceCreationLimitPolicy.wrap(buildAwsValue())
}
object ResourceCreationLimitPolicy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.ResourceCreationLimitPolicy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.ResourceCreationLimitPolicy =
      zio.aws.gamelift.model.ResourceCreationLimitPolicy(
        newGameSessionsPerCreator.map(value => value),
        policyPeriodInMinutes.map(value => value)
      )
    def newGameSessionsPerCreator: Option[WholeNumber]
    def policyPeriodInMinutes: Option[WholeNumber]
    def getNewGameSessionsPerCreator: ZIO[Any, AwsError, WholeNumber] = AwsError
      .unwrapOptionField("newGameSessionsPerCreator", newGameSessionsPerCreator)
    def getPolicyPeriodInMinutes: ZIO[Any, AwsError, WholeNumber] =
      AwsError.unwrapOptionField("policyPeriodInMinutes", policyPeriodInMinutes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.ResourceCreationLimitPolicy
  ) extends zio.aws.gamelift.model.ResourceCreationLimitPolicy.ReadOnly {
    override val newGameSessionsPerCreator: Option[WholeNumber] = scala
      .Option(impl.newGameSessionsPerCreator())
      .map(value => zio.aws.gamelift.model.primitives.WholeNumber(value))
    override val policyPeriodInMinutes: Option[WholeNumber] = scala
      .Option(impl.policyPeriodInMinutes())
      .map(value => zio.aws.gamelift.model.primitives.WholeNumber(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.ResourceCreationLimitPolicy
  ): zio.aws.gamelift.model.ResourceCreationLimitPolicy.ReadOnly = new Wrapper(
    impl
  )
}
