package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ResumeGameServerGroupResponse(
    gameServerGroup: Option[zio.aws.gamelift.model.GameServerGroup] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.ResumeGameServerGroupResponse = {
    import ResumeGameServerGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.ResumeGameServerGroupResponse
      .builder()
      .optionallyWith(gameServerGroup.map(value => value.buildAwsValue()))(
        _.gameServerGroup
      )
      .build()
  }
  def asReadOnly
      : zio.aws.gamelift.model.ResumeGameServerGroupResponse.ReadOnly =
    zio.aws.gamelift.model.ResumeGameServerGroupResponse.wrap(buildAwsValue())
}
object ResumeGameServerGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.ResumeGameServerGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.ResumeGameServerGroupResponse =
      zio.aws.gamelift.model.ResumeGameServerGroupResponse(
        gameServerGroup.map(value => value.asEditable)
      )
    def gameServerGroup: Option[zio.aws.gamelift.model.GameServerGroup.ReadOnly]
    def getGameServerGroup
        : ZIO[Any, AwsError, zio.aws.gamelift.model.GameServerGroup.ReadOnly] =
      AwsError.unwrapOptionField("gameServerGroup", gameServerGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.ResumeGameServerGroupResponse
  ) extends zio.aws.gamelift.model.ResumeGameServerGroupResponse.ReadOnly {
    override val gameServerGroup
        : Option[zio.aws.gamelift.model.GameServerGroup.ReadOnly] = scala
      .Option(impl.gameServerGroup())
      .map(value => zio.aws.gamelift.model.GameServerGroup.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.ResumeGameServerGroupResponse
  ): zio.aws.gamelift.model.ResumeGameServerGroupResponse.ReadOnly =
    new Wrapper(impl)
}
