package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.gamelift.model.primitives.{FreeText, FleetId}
import scala.jdk.CollectionConverters._
final case class RoutingStrategy(
    `type`: Option[zio.aws.gamelift.model.RoutingStrategyType] = None,
    fleetId: Option[FleetId] = None,
    message: Option[FreeText] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.RoutingStrategy = {
    import RoutingStrategy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.RoutingStrategy
      .builder()
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        fleetId.map(value => FleetId.unwrap(value): java.lang.String)
      )(_.fleetId)
      .optionallyWith(
        message.map(value => FreeText.unwrap(value): java.lang.String)
      )(_.message)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.RoutingStrategy.ReadOnly =
    zio.aws.gamelift.model.RoutingStrategy.wrap(buildAwsValue())
}
object RoutingStrategy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.RoutingStrategy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.RoutingStrategy =
      zio.aws.gamelift.model.RoutingStrategy(
        `type`.map(value => value),
        fleetId.map(value => value),
        message.map(value => value)
      )
    def `type`: Option[zio.aws.gamelift.model.RoutingStrategyType]
    def fleetId: Option[FleetId]
    def message: Option[FreeText]
    def getType
        : ZIO[Any, AwsError, zio.aws.gamelift.model.RoutingStrategyType] =
      AwsError.unwrapOptionField("type", `type`)
    def getFleetId: ZIO[Any, AwsError, FleetId] =
      AwsError.unwrapOptionField("fleetId", fleetId)
    def getMessage: ZIO[Any, AwsError, FreeText] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.RoutingStrategy
  ) extends zio.aws.gamelift.model.RoutingStrategy.ReadOnly {
    override val `type`: Option[zio.aws.gamelift.model.RoutingStrategyType] =
      scala
        .Option(impl.`type`())
        .map(value => zio.aws.gamelift.model.RoutingStrategyType.wrap(value))
    override val fleetId: Option[FleetId] = scala
      .Option(impl.fleetId())
      .map(value => zio.aws.gamelift.model.primitives.FleetId(value))
    override val message: Option[FreeText] = scala
      .Option(impl.message())
      .map(value => zio.aws.gamelift.model.primitives.FreeText(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.RoutingStrategy
  ): zio.aws.gamelift.model.RoutingStrategy.ReadOnly = new Wrapper(impl)
}
