package zio.aws.gamelift.model
import scala.jdk.CollectionConverters._
sealed trait RoutingStrategyType {
  def unwrap: software.amazon.awssdk.services.gamelift.model.RoutingStrategyType
}
object RoutingStrategyType {
  def wrap(
      value: software.amazon.awssdk.services.gamelift.model.RoutingStrategyType
  ): zio.aws.gamelift.model.RoutingStrategyType = value match {
    case software.amazon.awssdk.services.gamelift.model.RoutingStrategyType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.gamelift.model.RoutingStrategyType.SIMPLE =>
      val r = SIMPLE
      r
    case software.amazon.awssdk.services.gamelift.model.RoutingStrategyType.TERMINAL =>
      val r = TERMINAL
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.gamelift.model.RoutingStrategyType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.RoutingStrategyType =
      software.amazon.awssdk.services.gamelift.model.RoutingStrategyType.UNKNOWN_TO_SDK_VERSION
  }
  case object SIMPLE extends zio.aws.gamelift.model.RoutingStrategyType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.RoutingStrategyType =
      software.amazon.awssdk.services.gamelift.model.RoutingStrategyType.SIMPLE
  }
  case object TERMINAL extends zio.aws.gamelift.model.RoutingStrategyType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.RoutingStrategyType =
      software.amazon.awssdk.services.gamelift.model.RoutingStrategyType.TERMINAL
  }
}
