package zio.aws.gamelift.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.gamelift.model.primitives.{
  GameSessionActivationTimeoutSeconds,
  MaxConcurrentGameSessionActivations
}
import scala.jdk.CollectionConverters._
final case class RuntimeConfiguration(
    serverProcesses: Option[Iterable[zio.aws.gamelift.model.ServerProcess]] =
      None,
    maxConcurrentGameSessionActivations: Option[
      MaxConcurrentGameSessionActivations
    ] = None,
    gameSessionActivationTimeoutSeconds: Option[
      GameSessionActivationTimeoutSeconds
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.RuntimeConfiguration = {
    import RuntimeConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.RuntimeConfiguration
      .builder()
      .optionallyWith(
        serverProcesses.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.serverProcesses)
      .optionallyWith(
        maxConcurrentGameSessionActivations.map(value =>
          MaxConcurrentGameSessionActivations.unwrap(value): Integer
        )
      )(_.maxConcurrentGameSessionActivations)
      .optionallyWith(
        gameSessionActivationTimeoutSeconds.map(value =>
          GameSessionActivationTimeoutSeconds.unwrap(value): Integer
        )
      )(_.gameSessionActivationTimeoutSeconds)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.RuntimeConfiguration.ReadOnly =
    zio.aws.gamelift.model.RuntimeConfiguration.wrap(buildAwsValue())
}
object RuntimeConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.RuntimeConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.RuntimeConfiguration =
      zio.aws.gamelift.model.RuntimeConfiguration(
        serverProcesses.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxConcurrentGameSessionActivations.map(value => value),
        gameSessionActivationTimeoutSeconds.map(value => value)
      )
    def serverProcesses
        : Option[List[zio.aws.gamelift.model.ServerProcess.ReadOnly]]
    def maxConcurrentGameSessionActivations
        : Option[MaxConcurrentGameSessionActivations]
    def gameSessionActivationTimeoutSeconds
        : Option[GameSessionActivationTimeoutSeconds]
    def getServerProcesses: ZIO[Any, AwsError, List[
      zio.aws.gamelift.model.ServerProcess.ReadOnly
    ]] = AwsError.unwrapOptionField("serverProcesses", serverProcesses)
    def getMaxConcurrentGameSessionActivations
        : ZIO[Any, AwsError, MaxConcurrentGameSessionActivations] =
      AwsError.unwrapOptionField(
        "maxConcurrentGameSessionActivations",
        maxConcurrentGameSessionActivations
      )
    def getGameSessionActivationTimeoutSeconds
        : ZIO[Any, AwsError, GameSessionActivationTimeoutSeconds] =
      AwsError.unwrapOptionField(
        "gameSessionActivationTimeoutSeconds",
        gameSessionActivationTimeoutSeconds
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.RuntimeConfiguration
  ) extends zio.aws.gamelift.model.RuntimeConfiguration.ReadOnly {
    override val serverProcesses
        : Option[List[zio.aws.gamelift.model.ServerProcess.ReadOnly]] = scala
      .Option(impl.serverProcesses())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.gamelift.model.ServerProcess.wrap(item)
        }.toList
      )
    override val maxConcurrentGameSessionActivations
        : Option[MaxConcurrentGameSessionActivations] = scala
      .Option(impl.maxConcurrentGameSessionActivations())
      .map(value =>
        zio.aws.gamelift.model.primitives
          .MaxConcurrentGameSessionActivations(value)
      )
    override val gameSessionActivationTimeoutSeconds
        : Option[GameSessionActivationTimeoutSeconds] = scala
      .Option(impl.gameSessionActivationTimeoutSeconds())
      .map(value =>
        zio.aws.gamelift.model.primitives
          .GameSessionActivationTimeoutSeconds(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.RuntimeConfiguration
  ): zio.aws.gamelift.model.RuntimeConfiguration.ReadOnly = new Wrapper(impl)
}
