package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.gamelift.model.primitives.{
  FleetId,
  FleetArn,
  PositiveInteger,
  Integer,
  LocationStringModel,
  NonZeroAndMaxString
}
import scala.jdk.CollectionConverters._
final case class ScalingPolicy(
    fleetId: Option[FleetId] = None,
    fleetArn: Option[FleetArn] = None,
    name: Option[NonZeroAndMaxString] = None,
    status: Option[zio.aws.gamelift.model.ScalingStatusType] = None,
    scalingAdjustment: Option[Integer] = None,
    scalingAdjustmentType: Option[
      zio.aws.gamelift.model.ScalingAdjustmentType
    ] = None,
    comparisonOperator: Option[zio.aws.gamelift.model.ComparisonOperatorType] =
      None,
    threshold: Option[Double] = None,
    evaluationPeriods: Option[PositiveInteger] = None,
    metricName: Option[zio.aws.gamelift.model.MetricName] = None,
    policyType: Option[zio.aws.gamelift.model.PolicyType] = None,
    targetConfiguration: Option[zio.aws.gamelift.model.TargetConfiguration] =
      None,
    updateStatus: Option[zio.aws.gamelift.model.LocationUpdateStatus] = None,
    location: Option[LocationStringModel] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.ScalingPolicy = {
    import ScalingPolicy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.ScalingPolicy
      .builder()
      .optionallyWith(
        fleetId.map(value => FleetId.unwrap(value): java.lang.String)
      )(_.fleetId)
      .optionallyWith(
        fleetArn.map(value => FleetArn.unwrap(value): java.lang.String)
      )(_.fleetArn)
      .optionallyWith(
        name.map(value => NonZeroAndMaxString.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        scalingAdjustment.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.scalingAdjustment)
      .optionallyWith(scalingAdjustmentType.map(value => value.unwrap))(
        _.scalingAdjustmentType
      )
      .optionallyWith(comparisonOperator.map(value => value.unwrap))(
        _.comparisonOperator
      )
      .optionallyWith(threshold.map(value => value: java.lang.Double))(
        _.threshold
      )
      .optionallyWith(
        evaluationPeriods.map(value =>
          PositiveInteger.unwrap(value): java.lang.Integer
        )
      )(_.evaluationPeriods)
      .optionallyWith(metricName.map(value => value.unwrap))(_.metricName)
      .optionallyWith(policyType.map(value => value.unwrap))(_.policyType)
      .optionallyWith(targetConfiguration.map(value => value.buildAwsValue()))(
        _.targetConfiguration
      )
      .optionallyWith(updateStatus.map(value => value.unwrap))(_.updateStatus)
      .optionallyWith(
        location.map(value =>
          LocationStringModel.unwrap(value): java.lang.String
        )
      )(_.location)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.ScalingPolicy.ReadOnly =
    zio.aws.gamelift.model.ScalingPolicy.wrap(buildAwsValue())
}
object ScalingPolicy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.ScalingPolicy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.ScalingPolicy =
      zio.aws.gamelift.model.ScalingPolicy(
        fleetId.map(value => value),
        fleetArn.map(value => value),
        name.map(value => value),
        status.map(value => value),
        scalingAdjustment.map(value => value),
        scalingAdjustmentType.map(value => value),
        comparisonOperator.map(value => value),
        threshold.map(value => value),
        evaluationPeriods.map(value => value),
        metricName.map(value => value),
        policyType.map(value => value),
        targetConfiguration.map(value => value.asEditable),
        updateStatus.map(value => value),
        location.map(value => value)
      )
    def fleetId: Option[FleetId]
    def fleetArn: Option[FleetArn]
    def name: Option[NonZeroAndMaxString]
    def status: Option[zio.aws.gamelift.model.ScalingStatusType]
    def scalingAdjustment: Option[Integer]
    def scalingAdjustmentType
        : Option[zio.aws.gamelift.model.ScalingAdjustmentType]
    def comparisonOperator
        : Option[zio.aws.gamelift.model.ComparisonOperatorType]
    def threshold: Option[Double]
    def evaluationPeriods: Option[PositiveInteger]
    def metricName: Option[zio.aws.gamelift.model.MetricName]
    def policyType: Option[zio.aws.gamelift.model.PolicyType]
    def targetConfiguration
        : Option[zio.aws.gamelift.model.TargetConfiguration.ReadOnly]
    def updateStatus: Option[zio.aws.gamelift.model.LocationUpdateStatus]
    def location: Option[LocationStringModel]
    def getFleetId: ZIO[Any, AwsError, FleetId] =
      AwsError.unwrapOptionField("fleetId", fleetId)
    def getFleetArn: ZIO[Any, AwsError, FleetArn] =
      AwsError.unwrapOptionField("fleetArn", fleetArn)
    def getName: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("name", name)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.gamelift.model.ScalingStatusType] =
      AwsError.unwrapOptionField("status", status)
    def getScalingAdjustment: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("scalingAdjustment", scalingAdjustment)
    def getScalingAdjustmentType
        : ZIO[Any, AwsError, zio.aws.gamelift.model.ScalingAdjustmentType] =
      AwsError.unwrapOptionField("scalingAdjustmentType", scalingAdjustmentType)
    def getComparisonOperator
        : ZIO[Any, AwsError, zio.aws.gamelift.model.ComparisonOperatorType] =
      AwsError.unwrapOptionField("comparisonOperator", comparisonOperator)
    def getThreshold: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("threshold", threshold)
    def getEvaluationPeriods: ZIO[Any, AwsError, PositiveInteger] =
      AwsError.unwrapOptionField("evaluationPeriods", evaluationPeriods)
    def getMetricName: ZIO[Any, AwsError, zio.aws.gamelift.model.MetricName] =
      AwsError.unwrapOptionField("metricName", metricName)
    def getPolicyType: ZIO[Any, AwsError, zio.aws.gamelift.model.PolicyType] =
      AwsError.unwrapOptionField("policyType", policyType)
    def getTargetConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.gamelift.model.TargetConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("targetConfiguration", targetConfiguration)
    def getUpdateStatus
        : ZIO[Any, AwsError, zio.aws.gamelift.model.LocationUpdateStatus] =
      AwsError.unwrapOptionField("updateStatus", updateStatus)
    def getLocation: ZIO[Any, AwsError, LocationStringModel] =
      AwsError.unwrapOptionField("location", location)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.ScalingPolicy
  ) extends zio.aws.gamelift.model.ScalingPolicy.ReadOnly {
    override val fleetId: Option[FleetId] = scala
      .Option(impl.fleetId())
      .map(value => zio.aws.gamelift.model.primitives.FleetId(value))
    override val fleetArn: Option[FleetArn] = scala
      .Option(impl.fleetArn())
      .map(value => zio.aws.gamelift.model.primitives.FleetArn(value))
    override val name: Option[NonZeroAndMaxString] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
      )
    override val status: Option[zio.aws.gamelift.model.ScalingStatusType] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.gamelift.model.ScalingStatusType.wrap(value))
    override val scalingAdjustment: Option[Integer] = scala
      .Option(impl.scalingAdjustment())
      .map(value => zio.aws.gamelift.model.primitives.Integer(value))
    override val scalingAdjustmentType
        : Option[zio.aws.gamelift.model.ScalingAdjustmentType] = scala
      .Option(impl.scalingAdjustmentType())
      .map(value => zio.aws.gamelift.model.ScalingAdjustmentType.wrap(value))
    override val comparisonOperator
        : Option[zio.aws.gamelift.model.ComparisonOperatorType] = scala
      .Option(impl.comparisonOperator())
      .map(value => zio.aws.gamelift.model.ComparisonOperatorType.wrap(value))
    override val threshold: Option[Double] =
      scala.Option(impl.threshold()).map(value => value: Double)
    override val evaluationPeriods: Option[PositiveInteger] = scala
      .Option(impl.evaluationPeriods())
      .map(value => zio.aws.gamelift.model.primitives.PositiveInteger(value))
    override val metricName: Option[zio.aws.gamelift.model.MetricName] = scala
      .Option(impl.metricName())
      .map(value => zio.aws.gamelift.model.MetricName.wrap(value))
    override val policyType: Option[zio.aws.gamelift.model.PolicyType] = scala
      .Option(impl.policyType())
      .map(value => zio.aws.gamelift.model.PolicyType.wrap(value))
    override val targetConfiguration
        : Option[zio.aws.gamelift.model.TargetConfiguration.ReadOnly] = scala
      .Option(impl.targetConfiguration())
      .map(value => zio.aws.gamelift.model.TargetConfiguration.wrap(value))
    override val updateStatus
        : Option[zio.aws.gamelift.model.LocationUpdateStatus] = scala
      .Option(impl.updateStatus())
      .map(value => zio.aws.gamelift.model.LocationUpdateStatus.wrap(value))
    override val location: Option[LocationStringModel] = scala
      .Option(impl.location())
      .map(value =>
        zio.aws.gamelift.model.primitives.LocationStringModel(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.ScalingPolicy
  ): zio.aws.gamelift.model.ScalingPolicy.ReadOnly = new Wrapper(impl)
}
