package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.gamelift.model.primitives.{
  PositiveLong,
  Timestamp,
  ScriptId,
  ScriptArn,
  NonZeroAndMaxString
}
import scala.jdk.CollectionConverters._
final case class Script(
    scriptId: Option[ScriptId] = None,
    scriptArn: Option[ScriptArn] = None,
    name: Option[NonZeroAndMaxString] = None,
    version: Option[NonZeroAndMaxString] = None,
    sizeOnDisk: Option[PositiveLong] = None,
    creationTime: Option[Timestamp] = None,
    storageLocation: Option[zio.aws.gamelift.model.S3Location] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.gamelift.model.Script = {
    import Script.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.Script
      .builder()
      .optionallyWith(
        scriptId.map(value => ScriptId.unwrap(value): java.lang.String)
      )(_.scriptId)
      .optionallyWith(
        scriptArn.map(value => ScriptArn.unwrap(value): java.lang.String)
      )(_.scriptArn)
      .optionallyWith(
        name.map(value => NonZeroAndMaxString.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        version.map(value =>
          NonZeroAndMaxString.unwrap(value): java.lang.String
        )
      )(_.version)
      .optionallyWith(
        sizeOnDisk.map(value => PositiveLong.unwrap(value): java.lang.Long)
      )(_.sizeOnDisk)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(storageLocation.map(value => value.buildAwsValue()))(
        _.storageLocation
      )
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.Script.ReadOnly =
    zio.aws.gamelift.model.Script.wrap(buildAwsValue())
}
object Script {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.gamelift.model.Script] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.Script =
      zio.aws.gamelift.model.Script(
        scriptId.map(value => value),
        scriptArn.map(value => value),
        name.map(value => value),
        version.map(value => value),
        sizeOnDisk.map(value => value),
        creationTime.map(value => value),
        storageLocation.map(value => value.asEditable)
      )
    def scriptId: Option[ScriptId]
    def scriptArn: Option[ScriptArn]
    def name: Option[NonZeroAndMaxString]
    def version: Option[NonZeroAndMaxString]
    def sizeOnDisk: Option[PositiveLong]
    def creationTime: Option[Timestamp]
    def storageLocation: Option[zio.aws.gamelift.model.S3Location.ReadOnly]
    def getScriptId: ZIO[Any, AwsError, ScriptId] =
      AwsError.unwrapOptionField("scriptId", scriptId)
    def getScriptArn: ZIO[Any, AwsError, ScriptArn] =
      AwsError.unwrapOptionField("scriptArn", scriptArn)
    def getName: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("name", name)
    def getVersion: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("version", version)
    def getSizeOnDisk: ZIO[Any, AwsError, PositiveLong] =
      AwsError.unwrapOptionField("sizeOnDisk", sizeOnDisk)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getStorageLocation
        : ZIO[Any, AwsError, zio.aws.gamelift.model.S3Location.ReadOnly] =
      AwsError.unwrapOptionField("storageLocation", storageLocation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.Script
  ) extends zio.aws.gamelift.model.Script.ReadOnly {
    override val scriptId: Option[ScriptId] = scala
      .Option(impl.scriptId())
      .map(value => zio.aws.gamelift.model.primitives.ScriptId(value))
    override val scriptArn: Option[ScriptArn] = scala
      .Option(impl.scriptArn())
      .map(value => zio.aws.gamelift.model.primitives.ScriptArn(value))
    override val name: Option[NonZeroAndMaxString] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
      )
    override val version: Option[NonZeroAndMaxString] = scala
      .Option(impl.version())
      .map(value =>
        zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
      )
    override val sizeOnDisk: Option[PositiveLong] = scala
      .Option(impl.sizeOnDisk())
      .map(value => zio.aws.gamelift.model.primitives.PositiveLong(value))
    override val creationTime: Option[Timestamp] = scala
      .Option(impl.creationTime())
      .map(value => zio.aws.gamelift.model.primitives.Timestamp(value))
    override val storageLocation
        : Option[zio.aws.gamelift.model.S3Location.ReadOnly] = scala
      .Option(impl.storageLocation())
      .map(value => zio.aws.gamelift.model.S3Location.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.Script
  ): zio.aws.gamelift.model.Script.ReadOnly = new Wrapper(impl)
}
