package zio.aws.gamelift.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.gamelift.model.primitives.{
  FleetIdOrArn,
  PositiveInteger,
  LocationStringModel,
  NonZeroAndMaxString,
  AliasIdOrArn
}
import scala.jdk.CollectionConverters._
final case class SearchGameSessionsRequest(
    fleetId: Option[FleetIdOrArn] = None,
    aliasId: Option[AliasIdOrArn] = None,
    location: Option[LocationStringModel] = None,
    filterExpression: Option[NonZeroAndMaxString] = None,
    sortExpression: Option[NonZeroAndMaxString] = None,
    limit: Option[PositiveInteger] = None,
    nextToken: Option[NonZeroAndMaxString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.SearchGameSessionsRequest = {
    import SearchGameSessionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.SearchGameSessionsRequest
      .builder()
      .optionallyWith(
        fleetId.map(value => FleetIdOrArn.unwrap(value): java.lang.String)
      )(_.fleetId)
      .optionallyWith(
        aliasId.map(value => AliasIdOrArn.unwrap(value): java.lang.String)
      )(_.aliasId)
      .optionallyWith(
        location.map(value =>
          LocationStringModel.unwrap(value): java.lang.String
        )
      )(_.location)
      .optionallyWith(
        filterExpression.map(value =>
          NonZeroAndMaxString.unwrap(value): java.lang.String
        )
      )(_.filterExpression)
      .optionallyWith(
        sortExpression.map(value =>
          NonZeroAndMaxString.unwrap(value): java.lang.String
        )
      )(_.sortExpression)
      .optionallyWith(
        limit.map(value => PositiveInteger.unwrap(value): Integer)
      )(_.limit)
      .optionallyWith(
        nextToken.map(value =>
          NonZeroAndMaxString.unwrap(value): java.lang.String
        )
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.SearchGameSessionsRequest.ReadOnly =
    zio.aws.gamelift.model.SearchGameSessionsRequest.wrap(buildAwsValue())
}
object SearchGameSessionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.SearchGameSessionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.SearchGameSessionsRequest =
      zio.aws.gamelift.model.SearchGameSessionsRequest(
        fleetId.map(value => value),
        aliasId.map(value => value),
        location.map(value => value),
        filterExpression.map(value => value),
        sortExpression.map(value => value),
        limit.map(value => value),
        nextToken.map(value => value)
      )
    def fleetId: Option[FleetIdOrArn]
    def aliasId: Option[AliasIdOrArn]
    def location: Option[LocationStringModel]
    def filterExpression: Option[NonZeroAndMaxString]
    def sortExpression: Option[NonZeroAndMaxString]
    def limit: Option[PositiveInteger]
    def nextToken: Option[NonZeroAndMaxString]
    def getFleetId: ZIO[Any, AwsError, FleetIdOrArn] =
      AwsError.unwrapOptionField("fleetId", fleetId)
    def getAliasId: ZIO[Any, AwsError, AliasIdOrArn] =
      AwsError.unwrapOptionField("aliasId", aliasId)
    def getLocation: ZIO[Any, AwsError, LocationStringModel] =
      AwsError.unwrapOptionField("location", location)
    def getFilterExpression: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("filterExpression", filterExpression)
    def getSortExpression: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("sortExpression", sortExpression)
    def getLimit: ZIO[Any, AwsError, PositiveInteger] =
      AwsError.unwrapOptionField("limit", limit)
    def getNextToken: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.SearchGameSessionsRequest
  ) extends zio.aws.gamelift.model.SearchGameSessionsRequest.ReadOnly {
    override val fleetId: Option[FleetIdOrArn] = scala
      .Option(impl.fleetId())
      .map(value => zio.aws.gamelift.model.primitives.FleetIdOrArn(value))
    override val aliasId: Option[AliasIdOrArn] = scala
      .Option(impl.aliasId())
      .map(value => zio.aws.gamelift.model.primitives.AliasIdOrArn(value))
    override val location: Option[LocationStringModel] = scala
      .Option(impl.location())
      .map(value =>
        zio.aws.gamelift.model.primitives.LocationStringModel(value)
      )
    override val filterExpression: Option[NonZeroAndMaxString] = scala
      .Option(impl.filterExpression())
      .map(value =>
        zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
      )
    override val sortExpression: Option[NonZeroAndMaxString] = scala
      .Option(impl.sortExpression())
      .map(value =>
        zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
      )
    override val limit: Option[PositiveInteger] = scala
      .Option(impl.limit())
      .map(value => zio.aws.gamelift.model.primitives.PositiveInteger(value))
    override val nextToken: Option[NonZeroAndMaxString] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.SearchGameSessionsRequest
  ): zio.aws.gamelift.model.SearchGameSessionsRequest.ReadOnly = new Wrapper(
    impl
  )
}
