package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.gamelift.model.primitives.NonZeroAndMaxString
import scala.jdk.CollectionConverters._
final case class SearchGameSessionsResponse(
    gameSessions: Option[Iterable[zio.aws.gamelift.model.GameSession]] = None,
    nextToken: Option[NonZeroAndMaxString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.SearchGameSessionsResponse = {
    import SearchGameSessionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.SearchGameSessionsResponse
      .builder()
      .optionallyWith(
        gameSessions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.gameSessions)
      .optionallyWith(
        nextToken.map(value =>
          NonZeroAndMaxString.unwrap(value): java.lang.String
        )
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.SearchGameSessionsResponse.ReadOnly =
    zio.aws.gamelift.model.SearchGameSessionsResponse.wrap(buildAwsValue())
}
object SearchGameSessionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.SearchGameSessionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.SearchGameSessionsResponse =
      zio.aws.gamelift.model.SearchGameSessionsResponse(
        gameSessions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def gameSessions: Option[List[zio.aws.gamelift.model.GameSession.ReadOnly]]
    def nextToken: Option[NonZeroAndMaxString]
    def getGameSessions: ZIO[Any, AwsError, List[
      zio.aws.gamelift.model.GameSession.ReadOnly
    ]] = AwsError.unwrapOptionField("gameSessions", gameSessions)
    def getNextToken: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.SearchGameSessionsResponse
  ) extends zio.aws.gamelift.model.SearchGameSessionsResponse.ReadOnly {
    override val gameSessions
        : Option[List[zio.aws.gamelift.model.GameSession.ReadOnly]] = scala
      .Option(impl.gameSessions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.gamelift.model.GameSession.wrap(item)
        }.toList
      )
    override val nextToken: Option[NonZeroAndMaxString] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.SearchGameSessionsResponse
  ): zio.aws.gamelift.model.SearchGameSessionsResponse.ReadOnly = new Wrapper(
    impl
  )
}
