package zio.aws.gamelift.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.gamelift.model.primitives.{
  PositiveInteger,
  LaunchParametersStringModel,
  LaunchPathStringModel
}
import scala.jdk.CollectionConverters._
final case class ServerProcess(
    launchPath: LaunchPathStringModel,
    parameters: Option[LaunchParametersStringModel] = None,
    concurrentExecutions: PositiveInteger
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.ServerProcess = {
    import ServerProcess.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.ServerProcess
      .builder()
      .launchPath(LaunchPathStringModel.unwrap(launchPath): java.lang.String)
      .optionallyWith(
        parameters.map(value =>
          LaunchParametersStringModel.unwrap(value): java.lang.String
        )
      )(_.parameters)
      .concurrentExecutions(
        PositiveInteger.unwrap(concurrentExecutions): Integer
      )
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.ServerProcess.ReadOnly =
    zio.aws.gamelift.model.ServerProcess.wrap(buildAwsValue())
}
object ServerProcess {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.ServerProcess
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.ServerProcess =
      zio.aws.gamelift.model.ServerProcess(
        launchPath,
        parameters.map(value => value),
        concurrentExecutions
      )
    def launchPath: LaunchPathStringModel
    def parameters: Option[LaunchParametersStringModel]
    def concurrentExecutions: PositiveInteger
    def getLaunchPath: ZIO[Any, Nothing, LaunchPathStringModel] =
      ZIO.succeed(launchPath)
    def getParameters: ZIO[Any, AwsError, LaunchParametersStringModel] =
      AwsError.unwrapOptionField("parameters", parameters)
    def getConcurrentExecutions: ZIO[Any, Nothing, PositiveInteger] =
      ZIO.succeed(concurrentExecutions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.ServerProcess
  ) extends zio.aws.gamelift.model.ServerProcess.ReadOnly {
    override val launchPath: LaunchPathStringModel =
      zio.aws.gamelift.model.primitives.LaunchPathStringModel(impl.launchPath())
    override val parameters: Option[LaunchParametersStringModel] = scala
      .Option(impl.parameters())
      .map(value =>
        zio.aws.gamelift.model.primitives.LaunchParametersStringModel(value)
      )
    override val concurrentExecutions: PositiveInteger =
      zio.aws.gamelift.model.primitives
        .PositiveInteger(impl.concurrentExecutions())
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.ServerProcess
  ): zio.aws.gamelift.model.ServerProcess.ReadOnly = new Wrapper(impl)
}
