package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.gamelift.model.primitives.{LocationStringModel, FleetIdOrArn}
import scala.jdk.CollectionConverters._
final case class StartFleetActionsRequest(
    fleetId: FleetIdOrArn,
    actions: Iterable[zio.aws.gamelift.model.FleetAction],
    location: Option[LocationStringModel] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.StartFleetActionsRequest = {
    import StartFleetActionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.StartFleetActionsRequest
      .builder()
      .fleetId(FleetIdOrArn.unwrap(fleetId): java.lang.String)
      .actionsWithStrings(actions.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .optionallyWith(
        location.map(value =>
          LocationStringModel.unwrap(value): java.lang.String
        )
      )(_.location)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.StartFleetActionsRequest.ReadOnly =
    zio.aws.gamelift.model.StartFleetActionsRequest.wrap(buildAwsValue())
}
object StartFleetActionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.StartFleetActionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.StartFleetActionsRequest =
      zio.aws.gamelift.model.StartFleetActionsRequest(
        fleetId,
        actions,
        location.map(value => value)
      )
    def fleetId: FleetIdOrArn
    def actions: List[zio.aws.gamelift.model.FleetAction]
    def location: Option[LocationStringModel]
    def getFleetId: ZIO[Any, Nothing, FleetIdOrArn] = ZIO.succeed(fleetId)
    def getActions
        : ZIO[Any, Nothing, List[zio.aws.gamelift.model.FleetAction]] =
      ZIO.succeed(actions)
    def getLocation: ZIO[Any, AwsError, LocationStringModel] =
      AwsError.unwrapOptionField("location", location)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.StartFleetActionsRequest
  ) extends zio.aws.gamelift.model.StartFleetActionsRequest.ReadOnly {
    override val fleetId: FleetIdOrArn =
      zio.aws.gamelift.model.primitives.FleetIdOrArn(impl.fleetId())
    override val actions: List[zio.aws.gamelift.model.FleetAction] = impl
      .actions()
      .asScala
      .map { item =>
        zio.aws.gamelift.model.FleetAction.wrap(item)
      }
      .toList
    override val location: Option[LocationStringModel] = scala
      .Option(impl.location())
      .map(value =>
        zio.aws.gamelift.model.primitives.LocationStringModel(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.StartFleetActionsRequest
  ): zio.aws.gamelift.model.StartFleetActionsRequest.ReadOnly = new Wrapper(
    impl
  )
}
