package zio.aws.gamelift.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.gamelift.model.primitives.{
  WholeNumber,
  IdStringModel,
  LargeGameSessionData,
  NonZeroAndMaxString,
  GameSessionQueueNameOrArn
}
import scala.jdk.CollectionConverters._
final case class StartGameSessionPlacementRequest(
    placementId: IdStringModel,
    gameSessionQueueName: GameSessionQueueNameOrArn,
    gameProperties: Option[Iterable[zio.aws.gamelift.model.GameProperty]] =
      None,
    maximumPlayerSessionCount: WholeNumber,
    gameSessionName: Option[NonZeroAndMaxString] = None,
    playerLatencies: Option[Iterable[zio.aws.gamelift.model.PlayerLatency]] =
      None,
    desiredPlayerSessions: Option[
      Iterable[zio.aws.gamelift.model.DesiredPlayerSession]
    ] = None,
    gameSessionData: Option[LargeGameSessionData] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.StartGameSessionPlacementRequest = {
    import StartGameSessionPlacementRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.StartGameSessionPlacementRequest
      .builder()
      .placementId(IdStringModel.unwrap(placementId): java.lang.String)
      .gameSessionQueueName(
        GameSessionQueueNameOrArn.unwrap(gameSessionQueueName): java.lang.String
      )
      .optionallyWith(
        gameProperties.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.gameProperties)
      .maximumPlayerSessionCount(
        WholeNumber.unwrap(maximumPlayerSessionCount): Integer
      )
      .optionallyWith(
        gameSessionName.map(value =>
          NonZeroAndMaxString.unwrap(value): java.lang.String
        )
      )(_.gameSessionName)
      .optionallyWith(
        playerLatencies.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.playerLatencies)
      .optionallyWith(
        desiredPlayerSessions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.desiredPlayerSessions)
      .optionallyWith(
        gameSessionData.map(value =>
          LargeGameSessionData.unwrap(value): java.lang.String
        )
      )(_.gameSessionData)
      .build()
  }
  def asReadOnly
      : zio.aws.gamelift.model.StartGameSessionPlacementRequest.ReadOnly =
    zio.aws.gamelift.model.StartGameSessionPlacementRequest
      .wrap(buildAwsValue())
}
object StartGameSessionPlacementRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.StartGameSessionPlacementRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.StartGameSessionPlacementRequest =
      zio.aws.gamelift.model.StartGameSessionPlacementRequest(
        placementId,
        gameSessionQueueName,
        gameProperties.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maximumPlayerSessionCount,
        gameSessionName.map(value => value),
        playerLatencies.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        desiredPlayerSessions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        gameSessionData.map(value => value)
      )
    def placementId: IdStringModel
    def gameSessionQueueName: GameSessionQueueNameOrArn
    def gameProperties
        : Option[List[zio.aws.gamelift.model.GameProperty.ReadOnly]]
    def maximumPlayerSessionCount: WholeNumber
    def gameSessionName: Option[NonZeroAndMaxString]
    def playerLatencies
        : Option[List[zio.aws.gamelift.model.PlayerLatency.ReadOnly]]
    def desiredPlayerSessions
        : Option[List[zio.aws.gamelift.model.DesiredPlayerSession.ReadOnly]]
    def gameSessionData: Option[LargeGameSessionData]
    def getPlacementId: ZIO[Any, Nothing, IdStringModel] =
      ZIO.succeed(placementId)
    def getGameSessionQueueName: ZIO[Any, Nothing, GameSessionQueueNameOrArn] =
      ZIO.succeed(gameSessionQueueName)
    def getGameProperties: ZIO[Any, AwsError, List[
      zio.aws.gamelift.model.GameProperty.ReadOnly
    ]] = AwsError.unwrapOptionField("gameProperties", gameProperties)
    def getMaximumPlayerSessionCount: ZIO[Any, Nothing, WholeNumber] =
      ZIO.succeed(maximumPlayerSessionCount)
    def getGameSessionName: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("gameSessionName", gameSessionName)
    def getPlayerLatencies: ZIO[Any, AwsError, List[
      zio.aws.gamelift.model.PlayerLatency.ReadOnly
    ]] = AwsError.unwrapOptionField("playerLatencies", playerLatencies)
    def getDesiredPlayerSessions: ZIO[Any, AwsError, List[
      zio.aws.gamelift.model.DesiredPlayerSession.ReadOnly
    ]] =
      AwsError.unwrapOptionField("desiredPlayerSessions", desiredPlayerSessions)
    def getGameSessionData: ZIO[Any, AwsError, LargeGameSessionData] =
      AwsError.unwrapOptionField("gameSessionData", gameSessionData)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.StartGameSessionPlacementRequest
  ) extends zio.aws.gamelift.model.StartGameSessionPlacementRequest.ReadOnly {
    override val placementId: IdStringModel =
      zio.aws.gamelift.model.primitives.IdStringModel(impl.placementId())
    override val gameSessionQueueName: GameSessionQueueNameOrArn =
      zio.aws.gamelift.model.primitives
        .GameSessionQueueNameOrArn(impl.gameSessionQueueName())
    override val gameProperties
        : Option[List[zio.aws.gamelift.model.GameProperty.ReadOnly]] = scala
      .Option(impl.gameProperties())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.gamelift.model.GameProperty.wrap(item)
        }.toList
      )
    override val maximumPlayerSessionCount: WholeNumber =
      zio.aws.gamelift.model.primitives
        .WholeNumber(impl.maximumPlayerSessionCount())
    override val gameSessionName: Option[NonZeroAndMaxString] = scala
      .Option(impl.gameSessionName())
      .map(value =>
        zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
      )
    override val playerLatencies
        : Option[List[zio.aws.gamelift.model.PlayerLatency.ReadOnly]] = scala
      .Option(impl.playerLatencies())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.gamelift.model.PlayerLatency.wrap(item)
        }.toList
      )
    override val desiredPlayerSessions
        : Option[List[zio.aws.gamelift.model.DesiredPlayerSession.ReadOnly]] =
      scala
        .Option(impl.desiredPlayerSessions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.gamelift.model.DesiredPlayerSession.wrap(item)
          }.toList
        )
    override val gameSessionData: Option[LargeGameSessionData] = scala
      .Option(impl.gameSessionData())
      .map(value =>
        zio.aws.gamelift.model.primitives.LargeGameSessionData(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.StartGameSessionPlacementRequest
  ): zio.aws.gamelift.model.StartGameSessionPlacementRequest.ReadOnly =
    new Wrapper(impl)
}
