package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.gamelift.model.primitives.{
  ArnStringModel,
  MatchmakingConfigurationName,
  MatchmakingIdStringModel
}
import scala.jdk.CollectionConverters._
final case class StartMatchBackfillRequest(
    ticketId: Option[MatchmakingIdStringModel] = None,
    configurationName: MatchmakingConfigurationName,
    gameSessionArn: Option[ArnStringModel] = None,
    players: Iterable[zio.aws.gamelift.model.Player]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.StartMatchBackfillRequest = {
    import StartMatchBackfillRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.StartMatchBackfillRequest
      .builder()
      .optionallyWith(
        ticketId.map(value =>
          MatchmakingIdStringModel.unwrap(value): java.lang.String
        )
      )(_.ticketId)
      .configurationName(
        MatchmakingConfigurationName.unwrap(configurationName): java.lang.String
      )
      .optionallyWith(
        gameSessionArn.map(value =>
          ArnStringModel.unwrap(value): java.lang.String
        )
      )(_.gameSessionArn)
      .players(players.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.StartMatchBackfillRequest.ReadOnly =
    zio.aws.gamelift.model.StartMatchBackfillRequest.wrap(buildAwsValue())
}
object StartMatchBackfillRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.StartMatchBackfillRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.StartMatchBackfillRequest =
      zio.aws.gamelift.model.StartMatchBackfillRequest(
        ticketId.map(value => value),
        configurationName,
        gameSessionArn.map(value => value),
        players.map { item =>
          item.asEditable
        }
      )
    def ticketId: Option[MatchmakingIdStringModel]
    def configurationName: MatchmakingConfigurationName
    def gameSessionArn: Option[ArnStringModel]
    def players: List[zio.aws.gamelift.model.Player.ReadOnly]
    def getTicketId: ZIO[Any, AwsError, MatchmakingIdStringModel] =
      AwsError.unwrapOptionField("ticketId", ticketId)
    def getConfigurationName: ZIO[Any, Nothing, MatchmakingConfigurationName] =
      ZIO.succeed(configurationName)
    def getGameSessionArn: ZIO[Any, AwsError, ArnStringModel] =
      AwsError.unwrapOptionField("gameSessionArn", gameSessionArn)
    def getPlayers
        : ZIO[Any, Nothing, List[zio.aws.gamelift.model.Player.ReadOnly]] =
      ZIO.succeed(players)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.StartMatchBackfillRequest
  ) extends zio.aws.gamelift.model.StartMatchBackfillRequest.ReadOnly {
    override val ticketId: Option[MatchmakingIdStringModel] = scala
      .Option(impl.ticketId())
      .map(value =>
        zio.aws.gamelift.model.primitives.MatchmakingIdStringModel(value)
      )
    override val configurationName: MatchmakingConfigurationName =
      zio.aws.gamelift.model.primitives
        .MatchmakingConfigurationName(impl.configurationName())
    override val gameSessionArn: Option[ArnStringModel] = scala
      .Option(impl.gameSessionArn())
      .map(value => zio.aws.gamelift.model.primitives.ArnStringModel(value))
    override val players: List[zio.aws.gamelift.model.Player.ReadOnly] = impl
      .players()
      .asScala
      .map { item =>
        zio.aws.gamelift.model.Player.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.StartMatchBackfillRequest
  ): zio.aws.gamelift.model.StartMatchBackfillRequest.ReadOnly = new Wrapper(
    impl
  )
}
