package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.gamelift.model.primitives.{
  MatchmakingConfigurationName,
  MatchmakingIdStringModel
}
import scala.jdk.CollectionConverters._
final case class StartMatchmakingRequest(
    ticketId: Option[MatchmakingIdStringModel] = None,
    configurationName: MatchmakingConfigurationName,
    players: Iterable[zio.aws.gamelift.model.Player]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.StartMatchmakingRequest = {
    import StartMatchmakingRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.StartMatchmakingRequest
      .builder()
      .optionallyWith(
        ticketId.map(value =>
          MatchmakingIdStringModel.unwrap(value): java.lang.String
        )
      )(_.ticketId)
      .configurationName(
        MatchmakingConfigurationName.unwrap(configurationName): java.lang.String
      )
      .players(players.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.StartMatchmakingRequest.ReadOnly =
    zio.aws.gamelift.model.StartMatchmakingRequest.wrap(buildAwsValue())
}
object StartMatchmakingRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.StartMatchmakingRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.StartMatchmakingRequest =
      zio.aws.gamelift.model.StartMatchmakingRequest(
        ticketId.map(value => value),
        configurationName,
        players.map { item =>
          item.asEditable
        }
      )
    def ticketId: Option[MatchmakingIdStringModel]
    def configurationName: MatchmakingConfigurationName
    def players: List[zio.aws.gamelift.model.Player.ReadOnly]
    def getTicketId: ZIO[Any, AwsError, MatchmakingIdStringModel] =
      AwsError.unwrapOptionField("ticketId", ticketId)
    def getConfigurationName: ZIO[Any, Nothing, MatchmakingConfigurationName] =
      ZIO.succeed(configurationName)
    def getPlayers
        : ZIO[Any, Nothing, List[zio.aws.gamelift.model.Player.ReadOnly]] =
      ZIO.succeed(players)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.StartMatchmakingRequest
  ) extends zio.aws.gamelift.model.StartMatchmakingRequest.ReadOnly {
    override val ticketId: Option[MatchmakingIdStringModel] = scala
      .Option(impl.ticketId())
      .map(value =>
        zio.aws.gamelift.model.primitives.MatchmakingIdStringModel(value)
      )
    override val configurationName: MatchmakingConfigurationName =
      zio.aws.gamelift.model.primitives
        .MatchmakingConfigurationName(impl.configurationName())
    override val players: List[zio.aws.gamelift.model.Player.ReadOnly] = impl
      .players()
      .asScala
      .map { item =>
        zio.aws.gamelift.model.Player.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.StartMatchmakingRequest
  ): zio.aws.gamelift.model.StartMatchmakingRequest.ReadOnly = new Wrapper(impl)
}
