package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class StartMatchmakingResponse(
    matchmakingTicket: Option[zio.aws.gamelift.model.MatchmakingTicket] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.StartMatchmakingResponse = {
    import StartMatchmakingResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.StartMatchmakingResponse
      .builder()
      .optionallyWith(matchmakingTicket.map(value => value.buildAwsValue()))(
        _.matchmakingTicket
      )
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.StartMatchmakingResponse.ReadOnly =
    zio.aws.gamelift.model.StartMatchmakingResponse.wrap(buildAwsValue())
}
object StartMatchmakingResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.StartMatchmakingResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.StartMatchmakingResponse =
      zio.aws.gamelift.model.StartMatchmakingResponse(
        matchmakingTicket.map(value => value.asEditable)
      )
    def matchmakingTicket
        : Option[zio.aws.gamelift.model.MatchmakingTicket.ReadOnly]
    def getMatchmakingTicket: ZIO[
      Any,
      AwsError,
      zio.aws.gamelift.model.MatchmakingTicket.ReadOnly
    ] = AwsError.unwrapOptionField("matchmakingTicket", matchmakingTicket)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.StartMatchmakingResponse
  ) extends zio.aws.gamelift.model.StartMatchmakingResponse.ReadOnly {
    override val matchmakingTicket
        : Option[zio.aws.gamelift.model.MatchmakingTicket.ReadOnly] = scala
      .Option(impl.matchmakingTicket())
      .map(value => zio.aws.gamelift.model.MatchmakingTicket.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.StartMatchmakingResponse
  ): zio.aws.gamelift.model.StartMatchmakingResponse.ReadOnly = new Wrapper(
    impl
  )
}
