package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.gamelift.model.primitives.{FleetArn, FleetId}
import scala.jdk.CollectionConverters._
final case class StopFleetActionsResponse(
    fleetId: Option[FleetId] = None,
    fleetArn: Option[FleetArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.StopFleetActionsResponse = {
    import StopFleetActionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.StopFleetActionsResponse
      .builder()
      .optionallyWith(
        fleetId.map(value => FleetId.unwrap(value): java.lang.String)
      )(_.fleetId)
      .optionallyWith(
        fleetArn.map(value => FleetArn.unwrap(value): java.lang.String)
      )(_.fleetArn)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.StopFleetActionsResponse.ReadOnly =
    zio.aws.gamelift.model.StopFleetActionsResponse.wrap(buildAwsValue())
}
object StopFleetActionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.StopFleetActionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.StopFleetActionsResponse =
      zio.aws.gamelift.model.StopFleetActionsResponse(
        fleetId.map(value => value),
        fleetArn.map(value => value)
      )
    def fleetId: Option[FleetId]
    def fleetArn: Option[FleetArn]
    def getFleetId: ZIO[Any, AwsError, FleetId] =
      AwsError.unwrapOptionField("fleetId", fleetId)
    def getFleetArn: ZIO[Any, AwsError, FleetArn] =
      AwsError.unwrapOptionField("fleetArn", fleetArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.StopFleetActionsResponse
  ) extends zio.aws.gamelift.model.StopFleetActionsResponse.ReadOnly {
    override val fleetId: Option[FleetId] = scala
      .Option(impl.fleetId())
      .map(value => zio.aws.gamelift.model.primitives.FleetId(value))
    override val fleetArn: Option[FleetArn] = scala
      .Option(impl.fleetArn())
      .map(value => zio.aws.gamelift.model.primitives.FleetArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.StopFleetActionsResponse
  ): zio.aws.gamelift.model.StopFleetActionsResponse.ReadOnly = new Wrapper(
    impl
  )
}
