package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.gamelift.model.primitives.MatchmakingIdStringModel
import scala.jdk.CollectionConverters._
final case class StopMatchmakingRequest(ticketId: MatchmakingIdStringModel) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.StopMatchmakingRequest = {
    import StopMatchmakingRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.StopMatchmakingRequest
      .builder()
      .ticketId(MatchmakingIdStringModel.unwrap(ticketId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.StopMatchmakingRequest.ReadOnly =
    zio.aws.gamelift.model.StopMatchmakingRequest.wrap(buildAwsValue())
}
object StopMatchmakingRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.StopMatchmakingRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.StopMatchmakingRequest =
      zio.aws.gamelift.model.StopMatchmakingRequest(ticketId)
    def ticketId: MatchmakingIdStringModel
    def getTicketId: ZIO[Any, Nothing, MatchmakingIdStringModel] =
      ZIO.succeed(ticketId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.StopMatchmakingRequest
  ) extends zio.aws.gamelift.model.StopMatchmakingRequest.ReadOnly {
    override val ticketId: MatchmakingIdStringModel =
      zio.aws.gamelift.model.primitives
        .MatchmakingIdStringModel(impl.ticketId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.StopMatchmakingRequest
  ): zio.aws.gamelift.model.StopMatchmakingRequest.ReadOnly = new Wrapper(impl)
}
