package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class SuspendGameServerGroupResponse(
    gameServerGroup: Option[zio.aws.gamelift.model.GameServerGroup] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.SuspendGameServerGroupResponse = {
    import SuspendGameServerGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.SuspendGameServerGroupResponse
      .builder()
      .optionallyWith(gameServerGroup.map(value => value.buildAwsValue()))(
        _.gameServerGroup
      )
      .build()
  }
  def asReadOnly
      : zio.aws.gamelift.model.SuspendGameServerGroupResponse.ReadOnly =
    zio.aws.gamelift.model.SuspendGameServerGroupResponse.wrap(buildAwsValue())
}
object SuspendGameServerGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.SuspendGameServerGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.SuspendGameServerGroupResponse =
      zio.aws.gamelift.model.SuspendGameServerGroupResponse(
        gameServerGroup.map(value => value.asEditable)
      )
    def gameServerGroup: Option[zio.aws.gamelift.model.GameServerGroup.ReadOnly]
    def getGameServerGroup
        : ZIO[Any, AwsError, zio.aws.gamelift.model.GameServerGroup.ReadOnly] =
      AwsError.unwrapOptionField("gameServerGroup", gameServerGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.SuspendGameServerGroupResponse
  ) extends zio.aws.gamelift.model.SuspendGameServerGroupResponse.ReadOnly {
    override val gameServerGroup
        : Option[zio.aws.gamelift.model.GameServerGroup.ReadOnly] = scala
      .Option(impl.gameServerGroup())
      .map(value => zio.aws.gamelift.model.GameServerGroup.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.SuspendGameServerGroupResponse
  ): zio.aws.gamelift.model.SuspendGameServerGroupResponse.ReadOnly =
    new Wrapper(impl)
}
