package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class TargetConfiguration(targetValue: Double) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.TargetConfiguration = {
    import TargetConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.TargetConfiguration
      .builder()
      .targetValue(targetValue: java.lang.Double)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.TargetConfiguration.ReadOnly =
    zio.aws.gamelift.model.TargetConfiguration.wrap(buildAwsValue())
}
object TargetConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.TargetConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.TargetConfiguration =
      zio.aws.gamelift.model.TargetConfiguration(targetValue)
    def targetValue: Double
    def getTargetValue: ZIO[Any, Nothing, Double] = ZIO.succeed(targetValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.TargetConfiguration
  ) extends zio.aws.gamelift.model.TargetConfiguration.ReadOnly {
    override val targetValue: Double = impl.targetValue(): Double
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.TargetConfiguration
  ): zio.aws.gamelift.model.TargetConfiguration.ReadOnly = new Wrapper(impl)
}
